/*
 * Decompiled with CFR 0.152.
 */
package org.pitest.mutationtest.engine.gregor.mutators.experimental;

import java.util.ArrayList;
import org.pitest.mutationtest.engine.MutationIdentifier;
import org.pitest.mutationtest.engine.gregor.Context;
import org.pitest.mutationtest.engine.gregor.MethodInfo;
import org.pitest.mutationtest.engine.gregor.MethodMutatorFactory;
import org.pitest.reloc.asm.Label;
import org.pitest.reloc.asm.MethodVisitor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RemoveSwitchMutator
implements MethodMutatorFactory {
    private final int key;

    public RemoveSwitchMutator(int i) {
        this.key = i;
    }

    public static Iterable<MethodMutatorFactory> makeMutators() {
        ArrayList<MethodMutatorFactory> variations = new ArrayList<MethodMutatorFactory>();
        for (int i = 0; i != 100; ++i) {
            variations.add(new RemoveSwitchMutator(i));
        }
        return variations;
    }

    @Override
    public MethodVisitor create(Context context, MethodInfo methodInfo, MethodVisitor methodVisitor) {
        return new RemoveSwitchMethodVisitor(context, methodVisitor);
    }

    @Override
    public String getGloballyUniqueId() {
        return this.getClass().getName() + "_" + this.key;
    }

    @Override
    public String getName() {
        return this.toString();
    }

    public String toString() {
        return "EXPERIMENTAL_REMOVE_SWITCH_MUTATOR_" + this.key;
    }

    private final class RemoveSwitchMethodVisitor
    extends MethodVisitor {
        private final Context context;

        public RemoveSwitchMethodVisitor(Context context, MethodVisitor methodVisitor) {
            super(327680, methodVisitor);
            this.context = context;
        }

        public void visitTableSwitchInsn(int i, int i1, Label defaultLabel, Label ... labels) {
            if (labels.length > RemoveSwitchMutator.this.key && this.shouldMutate()) {
                Label[] newLabels = (Label[])labels.clone();
                newLabels[((RemoveSwitchMutator)RemoveSwitchMutator.this).key] = defaultLabel;
                super.visitTableSwitchInsn(i, i1, defaultLabel, newLabels);
            } else {
                super.visitTableSwitchInsn(i, i1, defaultLabel, labels);
            }
        }

        public void visitLookupSwitchInsn(Label defaultLabel, int[] ints, Label[] labels) {
            if (labels.length > RemoveSwitchMutator.this.key && this.shouldMutate()) {
                Label[] newLabels = (Label[])labels.clone();
                newLabels[((RemoveSwitchMutator)RemoveSwitchMutator.this).key] = defaultLabel;
                super.visitLookupSwitchInsn(defaultLabel, ints, newLabels);
            } else {
                super.visitLookupSwitchInsn(defaultLabel, ints, labels);
            }
        }

        private boolean shouldMutate() {
            MutationIdentifier mutationId = this.context.registerMutation(RemoveSwitchMutator.this, "RemoveSwitch " + RemoveSwitchMutator.this.key + " mutation");
            return this.context.shouldMutate(mutationId);
        }
    }
}

