/*
 * Decompiled with CFR 0.152.
 */
package org.pitest.mutationtest.execute;

import java.io.IOException;
import java.net.URL;
import java.util.Enumeration;
import java.util.NoSuchElementException;
import org.pitest.classpath.ClassPath;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultPITClassloader
extends ClassLoader {
    private final ClassPath classPath;

    public DefaultPITClassloader(ClassPath cp, ClassLoader parent) {
        super(parent);
        this.classPath = cp;
    }

    @Override
    protected Class<?> findClass(String name) throws ClassNotFoundException {
        try {
            byte[] b = this.classPath.getClassData(name);
            if (b == null) {
                throw new ClassNotFoundException(name);
            }
            this.definePackage(name);
            return this.defineClass(name, b);
        }
        catch (IOException exception) {
            throw new ClassNotFoundException(name, exception);
        }
    }

    private void definePackage(String name) {
        String pkgname;
        int i = name.lastIndexOf(46);
        if (i != -1 && this.getPackage(pkgname = name.substring(0, i)) == null) {
            this.definePackage(pkgname, null, null, null, null, null, null, null);
        }
    }

    protected Class<?> defineClass(String name, byte[] b) {
        return this.defineClass(name, b, 0, b.length);
    }

    @Override
    protected URL findResource(String name) {
        return this.classPath.findResource(name);
    }

    @Override
    protected Enumeration<URL> findResources(final String name) {
        return new Enumeration<URL>(){
            private URL element;
            {
                this.element = DefaultPITClassloader.this.findResource(name);
            }

            @Override
            public boolean hasMoreElements() {
                return this.element != null;
            }

            @Override
            public URL nextElement() {
                if (this.element != null) {
                    URL element = this.element;
                    this.element = null;
                    return element;
                }
                throw new NoSuchElementException();
            }
        };
    }
}

