/*
 * Decompiled with CFR 0.152.
 */
package org.pitest.mutationtest.execute;

import org.pitest.boot.HotSwapAgent;
import org.pitest.classinfo.ClassByteArraySource;
import org.pitest.classinfo.ClassName;
import org.pitest.functional.F3;
import org.pitest.util.Unchecked;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class HotSwap
implements F3<ClassName, ClassLoader, byte[], Boolean> {
    private final ClassByteArraySource byteSource;
    private byte[] lastClassPreMutation;
    private ClassName lastMutatedClass;
    private ClassLoader lastUsedLoader;

    HotSwap(ClassByteArraySource byteSource) {
        this.byteSource = byteSource;
    }

    @Override
    public Boolean apply(ClassName clazzName, ClassLoader loader, byte[] b) {
        try {
            this.restoreLastClass(this.byteSource, clazzName, loader);
            this.lastUsedLoader = loader;
            Class<?> clazz = Class.forName(clazzName.asJavaName(), false, loader);
            return HotSwapAgent.hotSwap(clazz, b);
        }
        catch (ClassNotFoundException e) {
            throw Unchecked.translateCheckedException(e);
        }
    }

    private void restoreLastClass(ClassByteArraySource byteSource, ClassName clazzName, ClassLoader loader) throws ClassNotFoundException {
        if (this.lastMutatedClass != null && !this.lastMutatedClass.equals(clazzName)) {
            this.restoreForLoader(this.lastUsedLoader);
            this.restoreForLoader(loader);
        }
        if (this.lastMutatedClass == null || !this.lastMutatedClass.equals(clazzName)) {
            this.lastClassPreMutation = byteSource.getBytes(clazzName.asJavaName()).value();
        }
        this.lastMutatedClass = clazzName;
    }

    private void restoreForLoader(ClassLoader loader) throws ClassNotFoundException {
        Class<?> clazz = Class.forName(this.lastMutatedClass.asJavaName(), false, loader);
        HotSwapAgent.hotSwap(clazz, this.lastClassPreMutation);
    }
}

