/*
 * Decompiled with CFR 0.152.
 */
package org.pitest.mutationtest.execute;

import java.io.IOException;
import java.lang.management.MemoryNotificationInfo;
import java.net.Socket;
import java.net.UnknownHostException;
import java.util.Collection;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.management.Notification;
import javax.management.NotificationListener;
import javax.management.openmbean.CompositeData;
import org.pitest.boot.HotSwapAgent;
import org.pitest.classinfo.ClassName;
import org.pitest.classpath.ClassloaderByteArraySource;
import org.pitest.execute.Pitest;
import org.pitest.execute.UnGroupedStrategy;
import org.pitest.functional.FCollection;
import org.pitest.functional.FunctionalList;
import org.pitest.functional.prelude.Prelude;
import org.pitest.mutationtest.execute.DefaultReporter;
import org.pitest.mutationtest.execute.HotSwap;
import org.pitest.mutationtest.execute.MutationTestWorker;
import org.pitest.mutationtest.execute.Reporter;
import org.pitest.mutationtest.execute.SlaveArguments;
import org.pitest.mutationtest.execute.TimeOutDecoratedTestSource;
import org.pitest.mutationtest.mocksupport.BendJavassistToMyWillTransformer;
import org.pitest.testapi.Configuration;
import org.pitest.testapi.TestUnit;
import org.pitest.util.CommandLineMessage;
import org.pitest.util.ExitCode;
import org.pitest.util.Functions;
import org.pitest.util.Glob;
import org.pitest.util.IsolationUtils;
import org.pitest.util.Log;
import org.pitest.util.MemoryWatchdog;
import org.pitest.util.SafeDataInputStream;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MutationTestSlave {
    private static final Logger LOG = Log.getLogger();
    private final SafeDataInputStream dis;
    private final Reporter reporter;

    public MutationTestSlave(SafeDataInputStream dis, Reporter reporter) {
        this.dis = dis;
        this.reporter = reporter;
    }

    public void run() {
        try {
            SlaveArguments paramsFromParent = this.dis.read(SlaveArguments.class);
            Log.setVerbose(paramsFromParent.isVerbose());
            ClassLoader loader = IsolationUtils.getContextClassLoader();
            ClassloaderByteArraySource byteSource = new ClassloaderByteArraySource(loader);
            HotSwap hotswap = new HotSwap(byteSource);
            MutationTestWorker worker = new MutationTestWorker(hotswap, paramsFromParent.engine.createMutator(byteSource), loader);
            List<TestUnit> tests = MutationTestSlave.findTestsForTestClasses(loader, paramsFromParent.testClasses, paramsFromParent.pitConfig);
            worker.run(paramsFromParent.mutations, this.reporter, new TimeOutDecoratedTestSource(paramsFromParent.timeoutStrategy, tests, this.reporter));
            this.reporter.done(ExitCode.OK);
        }
        catch (Throwable ex) {
            LOG.log(Level.WARNING, "Error during mutation test", ex);
            this.reporter.done(ExitCode.UNKNOWN_ERROR);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] args) {
        LOG.log(Level.FINE, "slave started");
        MutationTestSlave.enablePowerMockSupport();
        int port = Integer.valueOf(args[0]);
        Socket s = null;
        try {
            s = new Socket("localhost", port);
            SafeDataInputStream dis = new SafeDataInputStream(s.getInputStream());
            DefaultReporter reporter = new DefaultReporter(s.getOutputStream());
            MutationTestSlave.addMemoryWatchDog(reporter);
            MutationTestSlave instance = new MutationTestSlave(dis, reporter);
            instance.run();
        }
        catch (UnknownHostException ex) {
            LOG.log(Level.WARNING, "Error during mutation test", ex);
        }
        catch (IOException ex) {
            LOG.log(Level.WARNING, "Error during mutation test", ex);
        }
        catch (RuntimeException t) {
            LOG.log(Level.WARNING, "RuntimeException during mutation test", t);
        }
        finally {
            if (s != null) {
                MutationTestSlave.safelyCloseSocket(s);
            }
        }
    }

    private static List<TestUnit> findTestsForTestClasses(ClassLoader loader, Collection<ClassName> testClasses, Configuration pitConfig) {
        FunctionalList<Class<?>> tcs = FCollection.flatMap(testClasses, Functions.nameToClass(loader));
        return Pitest.findTestUnitsForAllSuppliedClasses(pitConfig, new UnGroupedStrategy(), tcs);
    }

    private static void enablePowerMockSupport() {
        HotSwapAgent.addTransformer(new BendJavassistToMyWillTransformer(Prelude.or(new Glob("javassist/*"))));
    }

    private static void safelyCloseSocket(Socket s) {
        if (s != null) {
            try {
                s.close();
            }
            catch (IOException e) {
                LOG.log(Level.WARNING, "Couldn't close socket", e);
            }
        }
    }

    private static void addMemoryWatchDog(final Reporter r) {
        NotificationListener listener = new NotificationListener(){

            public void handleNotification(Notification notification, Object handback) {
                String type = notification.getType();
                if (type.equals("java.management.memory.threshold.exceeded")) {
                    CompositeData cd = (CompositeData)notification.getUserData();
                    MemoryNotificationInfo memInfo = MemoryNotificationInfo.from(cd);
                    CommandLineMessage.report(memInfo.getPoolName() + " has exceeded the shutdown threshold : " + memInfo.getCount() + " times.\n" + memInfo.getUsage());
                    r.done(ExitCode.OUT_OF_MEMORY);
                } else {
                    LOG.warning("Unknown notification: " + notification);
                }
            }
        };
        MemoryWatchdog.addWatchDogToAllPools(90L, listener);
    }
}

