/*
 * Decompiled with CFR 0.152.
 */
package org.pitest.mutationtest.execute;

import java.io.IOException;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.logging.Logger;
import org.pitest.classinfo.ClassName;
import org.pitest.classpath.ClassPath;
import org.pitest.execute.Container;
import org.pitest.execute.DefaultStaticConfig;
import org.pitest.execute.ExitingResultCollector;
import org.pitest.execute.MultipleTestGroup;
import org.pitest.execute.Pitest;
import org.pitest.execute.containers.ConcreteResultCollector;
import org.pitest.execute.containers.UnContainer;
import org.pitest.functional.F3;
import org.pitest.mutationtest.DetectionStatus;
import org.pitest.mutationtest.MutationStatusTestPair;
import org.pitest.mutationtest.engine.Mutant;
import org.pitest.mutationtest.engine.Mutater;
import org.pitest.mutationtest.engine.MutationDetails;
import org.pitest.mutationtest.engine.MutationIdentifier;
import org.pitest.mutationtest.execute.CheckTestHasFailedResultListener;
import org.pitest.mutationtest.execute.DefaultPITClassloader;
import org.pitest.mutationtest.execute.Reporter;
import org.pitest.mutationtest.execute.TimeOutDecoratedTestSource;
import org.pitest.mutationtest.mocksupport.JavassistInterceptor;
import org.pitest.testapi.TestUnit;
import org.pitest.util.IsolationUtils;
import org.pitest.util.Log;
import org.pitest.util.Unchecked;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MutationTestWorker {
    private static final Logger LOG = Log.getLogger();
    private final Mutater mutater;
    private final ClassLoader loader;
    private final F3<ClassName, ClassLoader, byte[], Boolean> hotswap;

    public MutationTestWorker(F3<ClassName, ClassLoader, byte[], Boolean> hotswap, Mutater mutater, ClassLoader loader) {
        this.loader = loader;
        this.mutater = mutater;
        this.hotswap = hotswap;
    }

    protected void run(Collection<MutationDetails> range, Reporter r, TimeOutDecoratedTestSource testSource) throws IOException {
        for (MutationDetails mutation : range) {
            LOG.fine("Running mutation " + mutation);
            long t0 = System.currentTimeMillis();
            this.processMutation(r, testSource, mutation);
            LOG.fine("processed mutation in " + (System.currentTimeMillis() - t0) + " ms.");
        }
    }

    private void processMutation(Reporter r, TimeOutDecoratedTestSource testSource, MutationDetails mutationDetails) throws IOException {
        MutationIdentifier mutationId = mutationDetails.getId();
        Mutant mutatedClass = this.mutater.getMutation(mutationId);
        JavassistInterceptor.setMutant(mutatedClass);
        LOG.fine("mutating method " + mutatedClass.getDetails().getMethod());
        List<TestUnit> relevantTests = testSource.translateTests(mutationDetails.getTestsInOrder());
        r.describe(mutationId);
        MutationStatusTestPair mutationDetected = this.handleMutation(mutationDetails, mutatedClass, relevantTests);
        r.report(mutationId, mutationDetected);
        LOG.fine("Mutation " + mutationId + " detected = " + mutationDetected);
    }

    private MutationStatusTestPair handleMutation(MutationDetails mutationId, Mutant mutatedClass, List<TestUnit> relevantTests) {
        MutationStatusTestPair mutationDetected;
        if (relevantTests == null || relevantTests.isEmpty()) {
            LOG.info("No test coverage for mutation  " + mutationId + " in " + mutatedClass.getDetails().getMethod());
            mutationDetected = new MutationStatusTestPair(0, DetectionStatus.RUN_ERROR);
        } else {
            mutationDetected = this.handleCoveredMutation(mutationId, mutatedClass, relevantTests);
        }
        return mutationDetected;
    }

    private MutationStatusTestPair handleCoveredMutation(MutationDetails mutationId, Mutant mutatedClass, List<TestUnit> relevantTests) {
        MutationStatusTestPair mutationDetected;
        LOG.fine("" + relevantTests.size() + " relevant test for " + mutatedClass.getDetails().getMethod());
        ClassLoader activeloader = this.pickClassLoaderForMutant(mutationId);
        Container c = MutationTestWorker.createNewContainer(activeloader);
        long t0 = System.currentTimeMillis();
        if (this.hotswap.apply(mutationId.getClassName(), activeloader, mutatedClass.getBytes()).booleanValue()) {
            LOG.fine("replaced class with mutant in " + (System.currentTimeMillis() - t0) + " ms");
            mutationDetected = this.doTestsDetectMutation(c, relevantTests);
        } else {
            LOG.warning("Mutation " + mutationId + " was not viable ");
            mutationDetected = new MutationStatusTestPair(0, DetectionStatus.NON_VIABLE);
        }
        return mutationDetected;
    }

    private static Container createNewContainer(final ClassLoader activeloader) {
        UnContainer c = new UnContainer(){

            public void submit(TestUnit group) {
                ExitingResultCollector rc = new ExitingResultCollector(new ConcreteResultCollector(this.feedbackQueue));
                group.execute(activeloader, rc);
            }
        };
        return c;
    }

    private ClassLoader pickClassLoaderForMutant(MutationDetails mutant) {
        if (mutant.mayPoisonJVM()) {
            LOG.fine("Creating new classloader for static initializer");
            return new DefaultPITClassloader(new ClassPath(), IsolationUtils.bootClassLoader());
        }
        return this.loader;
    }

    public String toString() {
        return "MutationTestWorker [mutater=" + this.mutater + ", loader=" + this.loader + ", hotswap=" + this.hotswap + "]";
    }

    private MutationStatusTestPair doTestsDetectMutation(Container c, List<TestUnit> tests) {
        try {
            CheckTestHasFailedResultListener listener = new CheckTestHasFailedResultListener();
            DefaultStaticConfig staticConfig = new DefaultStaticConfig();
            staticConfig.addTestListener(listener);
            Pitest pit = new Pitest(staticConfig);
            pit.run(c, this.createEarlyExitTestGroup(tests));
            return this.createStatusTestPair(listener);
        }
        catch (Exception ex) {
            throw Unchecked.translateCheckedException(ex);
        }
    }

    private MutationStatusTestPair createStatusTestPair(CheckTestHasFailedResultListener listener) {
        if (listener.lastFailingTest().hasSome()) {
            return new MutationStatusTestPair(listener.getNumberOfTestsRun(), listener.status(), listener.lastFailingTest().value().getQualifiedName());
        }
        return new MutationStatusTestPair(listener.getNumberOfTestsRun(), listener.status());
    }

    private List<TestUnit> createEarlyExitTestGroup(List<TestUnit> tests) {
        return Collections.singletonList(new MultipleTestGroup(tests));
    }
}

