/*
 * Decompiled with CFR 0.152.
 */
package org.pitest.mutationtest.execute;

import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.FutureTask;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.pitest.extension.common.TestUnitDecorator;
import org.pitest.functional.SideEffect;
import org.pitest.mutationtest.TimeoutLengthStrategy;
import org.pitest.mutationtest.execute.TimingMetaDataResultCollector;
import org.pitest.testapi.ResultCollector;
import org.pitest.testapi.TestUnit;
import org.pitest.util.Unchecked;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class MutationTimeoutDecorator
extends TestUnitDecorator {
    private final TimeoutLengthStrategy timeOutStrategy;
    private final SideEffect timeOutSideEffect;
    private final long executionTime;

    public MutationTimeoutDecorator(TestUnit child, SideEffect timeOutSideEffect, TimeoutLengthStrategy timeStrategy, long executionTime) {
        super(child);
        this.timeOutSideEffect = timeOutSideEffect;
        this.executionTime = executionTime;
        this.timeOutStrategy = timeStrategy;
    }

    @Override
    public void execute(ClassLoader loader, ResultCollector rc) {
        long maxTime = this.timeOutStrategy.getAllowedTime(this.executionTime);
        FutureTask<?> future = this.createFutureForChildTestUnit(loader, rc);
        this.executeFutureWithTimeOut(maxTime, future);
        if (!future.isDone()) {
            this.timeOutSideEffect.apply();
        }
    }

    private void executeFutureWithTimeOut(long maxTime, FutureTask<?> future) {
        try {
            future.get(maxTime, TimeUnit.MILLISECONDS);
        }
        catch (TimeoutException ex) {
        }
        catch (InterruptedException e) {
        }
        catch (ExecutionException e) {
            throw Unchecked.translateCheckedException(e);
        }
    }

    private FutureTask<?> createFutureForChildTestUnit(ClassLoader loader, ResultCollector rc) {
        FutureTask<Object> future = new FutureTask<Object>(this.createCallableForChild(loader, rc));
        Thread thread = new Thread(future);
        thread.setDaemon(true);
        thread.setName("mutationTestThread");
        thread.start();
        return future;
    }

    private Callable<Object> createCallableForChild(final ClassLoader loader, final ResultCollector rc) {
        return new Callable<Object>(){

            @Override
            public Object call() throws Exception {
                MutationTimeoutDecorator.this.child().execute(loader, new TimingMetaDataResultCollector(rc, MutationTimeoutDecorator.this.executionTime));
                return null;
            }
        };
    }
}

