/*
 * Decompiled with CFR 0.152.
 */
package org.pitest.mutationtest.execute;

import java.util.ArrayList;
import java.util.Arrays;
import org.pitest.mutationtest.execute.TimingMetaData;
import org.pitest.testapi.Description;
import org.pitest.testapi.MetaData;
import org.pitest.testapi.ResultCollector;

class TimingMetaDataResultCollector
implements ResultCollector {
    private final ResultCollector child;
    private final long time;

    TimingMetaDataResultCollector(ResultCollector child, long executionTime) {
        this.child = child;
        this.time = executionTime;
    }

    public void notifyEnd(Description description, Throwable t, MetaData ... data) {
        this.child.notifyEnd(description, t, this.addTimingToMetaData(data));
    }

    private MetaData[] addTimingToMetaData(MetaData ... data) {
        ArrayList<MetaData> md = new ArrayList<MetaData>(Arrays.asList(data));
        md.add(new TimingMetaData(this.time));
        return md.toArray(new MetaData[0]);
    }

    public void notifyEnd(Description description, MetaData ... data) {
        this.child.notifyEnd(description, this.addTimingToMetaData(data));
    }

    public void notifyStart(Description description) {
        this.child.notifyStart(description);
    }

    public void notifySkipped(Description description) {
        this.child.notifySkipped(description);
    }

    public boolean shouldExit() {
        return this.child.shouldExit();
    }
}

