/*
 * Decompiled with CFR 0.152.
 */
package org.pitest.mutationtest.filter;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.pitest.classpath.CodeSource;
import org.pitest.functional.F;
import org.pitest.functional.FCollection;
import org.pitest.functional.FunctionalList;
import org.pitest.mutationtest.filter.CompoundMutationFilter;
import org.pitest.mutationtest.filter.MutationFilter;
import org.pitest.mutationtest.filter.MutationFilterFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CompoundFilterFactory
implements MutationFilterFactory {
    private final List<MutationFilterFactory> children = new ArrayList<MutationFilterFactory>();

    public CompoundFilterFactory(Collection<? extends MutationFilterFactory> filters) {
        this.children.addAll(filters);
    }

    @Override
    public String description() {
        return null;
    }

    @Override
    public MutationFilter createFilter(CodeSource source, int maxMutationsPerClass) {
        FunctionalList<MutationFilter> filters = FCollection.map(this.children, CompoundFilterFactory.toFilter(source, maxMutationsPerClass));
        return new CompoundMutationFilter(filters);
    }

    private static F<MutationFilterFactory, MutationFilter> toFilter(final CodeSource source, final int maxMutationsPerClass) {
        return new F<MutationFilterFactory, MutationFilter>(){

            @Override
            public MutationFilter apply(MutationFilterFactory a) {
                return a.createFilter(source, maxMutationsPerClass);
            }
        };
    }
}

