/*
 * Decompiled with CFR 0.152.
 */
package org.pitest.mutationtest.filter;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import org.pitest.mutationtest.engine.MutationDetails;
import org.pitest.mutationtest.filter.MutationFilter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LimitNumberOfMutationPerClassFilter
implements MutationFilter {
    private final int maxMutationsPerClass;

    public LimitNumberOfMutationPerClassFilter(int max) {
        this.maxMutationsPerClass = max;
    }

    @Override
    public Collection<MutationDetails> filter(Collection<MutationDetails> mutations) {
        if (mutations.size() <= this.maxMutationsPerClass) {
            return mutations;
        }
        return this.createEvenlyDistributedSampling(mutations);
    }

    private Collection<MutationDetails> createEvenlyDistributedSampling(Collection<MutationDetails> mutations) {
        ArrayList<MutationDetails> filtered = new ArrayList<MutationDetails>(this.maxMutationsPerClass);
        int step = mutations.size() / this.maxMutationsPerClass;
        Iterator<MutationDetails> it = mutations.iterator();
        while (it.hasNext()) {
            MutationDetails value = null;
            for (int i = 0; it.hasNext() && i != step; ++i) {
                value = it.next();
            }
            if (filtered.size() == this.maxMutationsPerClass) continue;
            filtered.add(value);
        }
        return filtered;
    }
}

