/*
 * Decompiled with CFR 0.152.
 */
package org.pitest.mutationtest.incremental;

import java.math.BigInteger;
import java.util.Map;
import org.pitest.classinfo.ClassInfo;
import org.pitest.classinfo.ClassInfoSource;
import org.pitest.classinfo.ClassName;
import org.pitest.classpath.CodeSource;
import org.pitest.functional.Option;
import org.pitest.mutationtest.ClassHistory;
import org.pitest.mutationtest.HistoryStore;
import org.pitest.mutationtest.MutationStatusTestPair;
import org.pitest.mutationtest.engine.MutationIdentifier;
import org.pitest.mutationtest.incremental.CodeHistory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultCodeHistory
implements CodeHistory {
    private final ClassInfoSource code;
    private final Map<MutationIdentifier, MutationStatusTestPair> previousResults;
    private final Map<ClassName, ClassHistory> previousClassPath;

    public DefaultCodeHistory(CodeSource code, HistoryStore historyStore) {
        this(code, historyStore.getHistoricResults(), historyStore.getHistoricClassPath());
    }

    public DefaultCodeHistory(ClassInfoSource code, Map<MutationIdentifier, MutationStatusTestPair> previousResults, Map<ClassName, ClassHistory> previousClassPath) {
        this.code = code;
        this.previousResults = previousResults;
        this.previousClassPath = previousClassPath;
    }

    @Override
    public Option<MutationStatusTestPair> getPreviousResult(MutationIdentifier id) {
        return Option.some(this.previousResults.get(id));
    }

    @Override
    public boolean hasClassChanged(ClassName className) {
        ClassHistory historic = this.previousClassPath.get(className);
        if (historic == null) {
            return true;
        }
        Option<ClassInfo> current = this.code.fetchClass(className);
        return !current.value().getHierarchicalId().equals(historic.getId());
    }

    @Override
    public boolean hasCoverageChanged(ClassName className, BigInteger currentCoverage) {
        return !this.previousClassPath.get(className).getCoverageId().equals(currentCoverage.toString(16));
    }
}

