/*
 * Decompiled with CFR 0.152.
 */
package org.pitest.mutationtest.incremental;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.Reader;
import java.io.StringWriter;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Logger;
import org.pitest.classinfo.ClassIdentifier;
import org.pitest.classinfo.ClassName;
import org.pitest.classinfo.HierarchicalClassId;
import org.pitest.coverage.CoverageDatabase;
import org.pitest.functional.Option;
import org.pitest.mutationtest.ClassHistory;
import org.pitest.mutationtest.DetectionStatus;
import org.pitest.mutationtest.HistoryStore;
import org.pitest.mutationtest.MutationResult;
import org.pitest.mutationtest.MutationStatusTestPair;
import org.pitest.mutationtest.engine.MutationIdentifier;
import org.pitest.mutationtest.incremental.WriterFactory;
import org.pitest.reloc.xstream.XStream;
import org.pitest.reloc.xstream.io.StreamException;
import org.pitest.reloc.xstream.io.xml.CompactWriter;
import org.pitest.util.Log;
import org.pitest.util.PitXmlDriver;
import org.pitest.util.Unchecked;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class XStreamHistoryStore
implements HistoryStore {
    private static final Logger LOG = Log.getLogger();
    private static final XStream XSTREAM_INSTANCE = XStreamHistoryStore.configureXStream();
    private final WriterFactory outputFactory;
    private final BufferedReader input;
    private final Map<MutationIdentifier, MutationStatusTestPair> previousResults = new HashMap<MutationIdentifier, MutationStatusTestPair>();
    private final Map<ClassName, ClassHistory> previousClassPath = new HashMap<ClassName, ClassHistory>();

    public XStreamHistoryStore(WriterFactory output, Option<Reader> input) {
        this.outputFactory = output;
        this.input = this.createReader(input);
    }

    private static XStream configureXStream() {
        XStream xstream = new XStream(new PitXmlDriver());
        xstream.alias("classHistory", ClassHistory.class);
        xstream.alias("fullClassId", HierarchicalClassId.class);
        xstream.alias("classId", ClassIdentifier.class);
        xstream.alias("name", ClassName.class);
        xstream.alias("result", IdResult.class);
        xstream.alias("statusTestPair", MutationStatusTestPair.class);
        xstream.alias("status", DetectionStatus.class);
        xstream.useAttributeFor(MutationStatusTestPair.class, "numberOfTestsRun");
        xstream.useAttributeFor(MutationStatusTestPair.class, "status");
        xstream.useAttributeFor(MutationStatusTestPair.class, "killingTest");
        xstream.useAttributeFor(ClassIdentifier.class, "name");
        xstream.useAttributeFor(ClassIdentifier.class, "hash");
        xstream.useAttributeFor(HierarchicalClassId.class, "hierarchicalHash");
        xstream.useAttributeFor(HierarchicalClassId.class, "classId");
        return xstream;
    }

    private BufferedReader createReader(Option<Reader> input) {
        if (input.hasSome()) {
            return new BufferedReader(input.value());
        }
        return null;
    }

    @Override
    public void recordClassPath(Collection<HierarchicalClassId> ids, CoverageDatabase coverageInfo) {
        PrintWriter output = this.outputFactory.create();
        output.println(ids.size());
        for (HierarchicalClassId each : ids) {
            ClassHistory coverage = new ClassHistory(each, coverageInfo.getCoverageIdForClass(each.getName()).toString(16));
            output.println(XStreamHistoryStore.toXml(coverage));
        }
        output.flush();
    }

    @Override
    public void recordResult(MutationResult result) {
        PrintWriter output = this.outputFactory.create();
        output.println(XStreamHistoryStore.toXml(new IdResult(result.getDetails().getId(), result.getStatusTestPair())));
        output.flush();
    }

    @Override
    public Map<MutationIdentifier, MutationStatusTestPair> getHistoricResults() {
        return this.previousResults;
    }

    @Override
    public Map<ClassName, ClassHistory> getHistoricClassPath() {
        return this.previousClassPath;
    }

    @Override
    public void initialize() {
        if (this.input != null) {
            this.restoreClassPath();
            this.restoreResults();
            try {
                this.input.close();
            }
            catch (IOException e) {
                throw Unchecked.translateCheckedException(e);
            }
        }
    }

    private void restoreResults() {
        try {
            String line = this.input.readLine();
            while (line != null) {
                IdResult result = (IdResult)XStreamHistoryStore.fromXml(line);
                this.previousResults.put(result.id, result.status);
                line = this.input.readLine();
            }
        }
        catch (IOException e) {
            LOG.warning("Could not read previous results");
        }
        catch (StreamException e) {
            LOG.warning("Could not read previous results");
        }
    }

    private void restoreClassPath() {
        try {
            long classPathSize = Long.valueOf(this.input.readLine());
            int i = 0;
            while ((long)i != classPathSize) {
                ClassHistory coverage = (ClassHistory)XStreamHistoryStore.fromXml(this.input.readLine());
                this.previousClassPath.put(coverage.getName(), coverage);
                ++i;
            }
        }
        catch (IOException e) {
            LOG.warning("Could not read previous classpath");
        }
        catch (StreamException e) {
            LOG.warning("Could not read previous classpath");
        }
    }

    private static Object fromXml(String xml) {
        return XSTREAM_INSTANCE.fromXML(xml);
    }

    private static String toXml(Object o) {
        StringWriter writer = new StringWriter();
        XSTREAM_INSTANCE.marshal(o, new CompactWriter(writer));
        return ((Object)writer).toString().replaceAll("\n", "");
    }

    private static class IdResult {
        final MutationIdentifier id;
        final MutationStatusTestPair status;

        IdResult(MutationIdentifier id, MutationStatusTestPair status) {
            this.id = id;
            this.status = status;
        }
    }
}

