/*
 * Decompiled with CFR 0.152.
 */
package org.pitest.mutationtest.mocksupport;

import java.lang.instrument.ClassFileTransformer;
import java.lang.instrument.IllegalClassFormatException;
import java.security.ProtectionDomain;
import org.pitest.bytecode.FrameOptions;
import org.pitest.functional.predicate.Predicate;
import org.pitest.mutationtest.mocksupport.JavassistInputStreamInterceptorAdapater;
import org.pitest.reloc.asm.ClassReader;
import org.pitest.reloc.asm.ClassWriter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BendJavassistToMyWillTransformer
implements ClassFileTransformer {
    private final Predicate<String> filter;

    public BendJavassistToMyWillTransformer(Predicate<String> filter) {
        this.filter = filter;
    }

    @Override
    public byte[] transform(ClassLoader loader, String className, Class<?> classBeingRedefined, ProtectionDomain protectionDomain, byte[] classfileBuffer) throws IllegalClassFormatException {
        if (this.shouldInclude(className)) {
            ClassReader reader = new ClassReader(classfileBuffer);
            ClassWriter writer = new ClassWriter(FrameOptions.pickFlags(classfileBuffer));
            reader.accept(new JavassistInputStreamInterceptorAdapater(writer), 8);
            return writer.toByteArray();
        }
        return null;
    }

    private boolean shouldInclude(String className) {
        return (Boolean)this.filter.apply(className);
    }
}

