/*
 * Decompiled with CFR 0.152.
 */
package org.pitest.mutationtest.mocksupport;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import org.pitest.classinfo.ClassName;
import org.pitest.mutationtest.engine.Mutant;
import org.pitest.reflection.Reflection;
import org.pitest.util.Unchecked;

public class JavassistInterceptor {
    private static Mutant mutant;

    private JavassistInterceptor() {
    }

    public static InputStream openClassfile(Object classPath, String name) {
        if (JavassistInterceptor.isMutatedClass(name)) {
            ByteArrayInputStream bais = new ByteArrayInputStream(mutant.getBytes());
            return bais;
        }
        return JavassistInterceptor.returnNormalBytes(classPath, name);
    }

    private static InputStream returnNormalBytes(Object classPath, String name) {
        try {
            return (InputStream)Reflection.publicMethod(classPath.getClass(), "openClassfile").invoke(classPath, name);
        }
        catch (Exception e) {
            throw Unchecked.translateCheckedException(e);
        }
    }

    private static boolean isMutatedClass(String name) {
        return mutant != null && mutant.getDetails().getClassName().equals(ClassName.fromString(name));
    }

    public static void setMutant(Mutant newMutant) {
        mutant = newMutant;
    }
}

