/*
 * Decompiled with CFR 0.152.
 */
package org.pitest.mutationtest.report.csv;

import java.io.IOException;
import java.io.Writer;
import org.pitest.functional.Option;
import org.pitest.mutationtest.ClassMutationResults;
import org.pitest.mutationtest.MutationResult;
import org.pitest.mutationtest.MutationResultListener;
import org.pitest.util.ResultOutputStrategy;
import org.pitest.util.Unchecked;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CSVReportListener
implements MutationResultListener {
    private final Writer out;

    public CSVReportListener(ResultOutputStrategy outputStrategy) {
        this(outputStrategy.createWriterForFile("mutations.csv"));
    }

    public CSVReportListener(Writer out) {
        this.out = out;
    }

    private String createKillingTestDesc(Option<String> killingTest) {
        if (killingTest.hasSome()) {
            return killingTest.value();
        }
        return "none";
    }

    private String makeCsv(Object ... os) {
        StringBuffer sb = new StringBuffer();
        for (int i = 0; i != os.length; ++i) {
            sb.append(os[i].toString());
            if (i == os.length - 1) continue;
            sb.append(",");
        }
        return sb.toString();
    }

    @Override
    public void runStart() {
    }

    @Override
    public void runEnd() {
        try {
            this.out.close();
        }
        catch (IOException e) {
            throw Unchecked.translateCheckedException(e);
        }
    }

    @Override
    public void handleMutationResult(ClassMutationResults metaData) {
        try {
            for (MutationResult mutation : metaData.getMutations()) {
                this.out.write(this.makeCsv(new Object[]{mutation.getDetails().getFilename(), mutation.getDetails().getClassName().asJavaName(), mutation.getDetails().getMutator(), mutation.getDetails().getMethod(), mutation.getDetails().getLineNumber(), mutation.getStatus(), this.createKillingTestDesc(mutation.getKillingTest())}) + System.getProperty("line.separator"));
            }
        }
        catch (IOException ex) {
            throw Unchecked.translateCheckedException(ex);
        }
    }
}

