/*
 * Decompiled with CFR 0.152.
 */
package org.pitest.mutationtest.report.xml;

import java.io.IOException;
import java.io.Writer;
import org.pitest.functional.Option;
import org.pitest.mutationtest.ClassMutationResults;
import org.pitest.mutationtest.MutationResult;
import org.pitest.mutationtest.MutationResultListener;
import org.pitest.mutationtest.engine.MutationDetails;
import org.pitest.mutationtest.report.xml.Tag;
import org.pitest.util.ResultOutputStrategy;
import org.pitest.util.StringUtil;
import org.pitest.util.Unchecked;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class XMLReportListener
implements MutationResultListener {
    private final Writer out;

    public XMLReportListener(ResultOutputStrategy outputStrategy) {
        this(outputStrategy.createWriterForFile("mutations.xml"));
    }

    public XMLReportListener(Writer out) {
        this.out = out;
    }

    private void writeResult(ClassMutationResults metaData) {
        for (MutationResult mutation : metaData.getMutations()) {
            this.writeMutationResultXML(mutation);
        }
    }

    private void writeMutationResultXML(MutationResult result) {
        this.write(this.makeNode(this.makeMutationNode(result), this.makeMutationAttributes(result), Tag.mutation) + "\n");
    }

    private String makeMutationAttributes(MutationResult result) {
        return "detected='" + result.getStatus().isDetected() + "' status='" + (Object)((Object)result.getStatus()) + "'";
    }

    private String makeMutationNode(MutationResult mutation) {
        MutationDetails details = mutation.getDetails();
        return this.makeNode(this.clean(details.getFilename()), Tag.sourceFile) + this.makeNode(this.clean(details.getClassName().asJavaName()), Tag.mutatedClass) + this.makeNode(this.clean(details.getMethod().name()), Tag.mutatedMethod) + this.makeNode(this.clean(details.getMethodDescription()), Tag.methodDescription) + this.makeNode("" + details.getLineNumber(), Tag.lineNumber) + this.makeNode(this.clean(details.getMutator()), Tag.mutator) + this.makeNode("" + details.getFirstIndex(), Tag.index) + this.makeNode(this.createKillingTestDesc(mutation.getKillingTest()), Tag.killingTest);
    }

    private String clean(String value) {
        return StringUtil.escapeBasicHtmlChars(value);
    }

    private String makeNode(String value, String attributes, Tag tag) {
        if (value != null) {
            return "<" + (Object)((Object)tag) + " " + attributes + ">" + value + "</" + (Object)((Object)tag) + ">";
        }
        return "<" + (Object)((Object)tag) + attributes + "/>";
    }

    private String makeNode(String value, Tag tag) {
        if (value != null) {
            return "<" + (Object)((Object)tag) + ">" + value + "</" + (Object)((Object)tag) + ">";
        }
        return "<" + (Object)((Object)tag) + "/>";
    }

    private String createKillingTestDesc(Option<String> killingTest) {
        if (killingTest.hasSome()) {
            return this.clean(killingTest.value());
        }
        return null;
    }

    private void write(String value) {
        try {
            this.out.write(value);
        }
        catch (IOException e) {
            throw Unchecked.translateCheckedException(e);
        }
    }

    @Override
    public void runStart() {
        this.write("<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n");
        this.write("<mutations>\n");
    }

    @Override
    public void handleMutationResult(ClassMutationResults metaData) {
        this.writeResult(metaData);
    }

    @Override
    public void runEnd() {
        try {
            this.write("</mutations>\n");
            this.out.close();
        }
        catch (IOException e) {
            throw Unchecked.translateCheckedException(e);
        }
    }
}

