/*
 * Decompiled with CFR 0.152.
 */
package org.pitest.mutationtest.statistics;

import java.io.PrintStream;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.util.Collection;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import org.pitest.functional.F2;
import org.pitest.functional.FCollection;
import org.pitest.functional.SideEffect1;
import org.pitest.mutationtest.MutationResult;
import org.pitest.mutationtest.statistics.Score;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MutationStatistics {
    private final Map<String, Score> mutatorTotalMap = new HashMap<String, Score>();
    private long numberOfTestsRun = 0L;

    public void registerResults(Collection<MutationResult> results) {
        FCollection.forEach(results, this.register());
    }

    private SideEffect1<MutationResult> register() {
        return new SideEffect1<MutationResult>(){

            @Override
            public void apply(MutationResult mr) {
                MutationStatistics.this.numberOfTestsRun = MutationStatistics.this.numberOfTestsRun + (long)mr.getNumberOfTestsRun();
                String key = mr.getDetails().getId().getMutator();
                Score total = (Score)MutationStatistics.this.mutatorTotalMap.get(key);
                if (total == null) {
                    total = new Score(key);
                    MutationStatistics.this.mutatorTotalMap.put(key, total);
                }
                total.registerResult(mr.getStatus());
            }
        };
    }

    public Iterable<Score> getScores() {
        return this.mutatorTotalMap.values();
    }

    public long getTotalMutations() {
        return FCollection.fold(MutationStatistics.addTotals(), 0L, this.mutatorTotalMap.values());
    }

    public long getTotalDetectedMutations() {
        return FCollection.fold(MutationStatistics.addDetectedTotals(), 0L, this.mutatorTotalMap.values());
    }

    public long getPercentageDetected() {
        if (this.getTotalMutations() == 0L) {
            return 100L;
        }
        if (this.getTotalDetectedMutations() == 0L) {
            return 0L;
        }
        return Math.round(100.0f / (float)this.getTotalMutations() * (float)this.getTotalDetectedMutations());
    }

    private static F2<Long, Score, Long> addDetectedTotals() {
        return new F2<Long, Score, Long>(){

            @Override
            public Long apply(Long a, Score b) {
                return a + b.getTotalDetectedMutations();
            }
        };
    }

    private static F2<Long, Score, Long> addTotals() {
        return new F2<Long, Score, Long>(){

            @Override
            public Long apply(Long a, Score b) {
                return a + b.getTotalMutations();
            }
        };
    }

    public void report(PrintStream out) {
        out.println(">> Generated " + this.getTotalMutations() + " mutations Killed " + this.getTotalDetectedMutations() + " (" + this.getPercentageDetected() + "%)");
        out.println(">> Ran " + this.numberOfTestsRun + " tests (" + this.getTestsPerMutation() + " tests per mutation)");
    }

    private String getTestsPerMutation() {
        if (this.getTotalMutations() == 0L) {
            return "0";
        }
        float testsPerMutation = (float)this.numberOfTestsRun / (float)this.getTotalMutations();
        return new DecimalFormat("#.##", new DecimalFormatSymbols(Locale.ENGLISH)).format(testsPerMutation);
    }
}

