/*
 * Decompiled with CFR 0.152.
 */
package org.pitest.mutationtest.statistics;

import java.io.PrintStream;
import java.util.LinkedHashMap;
import java.util.Map;
import org.pitest.functional.F;
import org.pitest.functional.F2;
import org.pitest.functional.FCollection;
import org.pitest.mutationtest.DetectionStatus;
import org.pitest.mutationtest.statistics.StatusCount;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Score {
    private final String mutatorName;
    private final Map<DetectionStatus, StatusCount> counts;

    public Score(String name) {
        this.mutatorName = name;
        this.counts = Score.createMap();
    }

    private static Map<DetectionStatus, StatusCount> createMap() {
        LinkedHashMap<DetectionStatus, StatusCount> map = new LinkedHashMap<DetectionStatus, StatusCount>();
        for (DetectionStatus each : DetectionStatus.values()) {
            map.put(each, new StatusCount(each, 0L));
        }
        return map;
    }

    public void registerResult(DetectionStatus result) {
        StatusCount total = this.counts.get((Object)result);
        total.increment();
    }

    public Iterable<StatusCount> getCounts() {
        return this.counts.values();
    }

    public long getTotalMutations() {
        return FCollection.fold(this.addTotals(), 0L, this.counts.values());
    }

    public long getTotalDetectedMutations() {
        return FCollection.fold(this.addTotals(), 0L, FCollection.filter(this.counts.values(), Score.isDetected()));
    }

    public long getPercentageDetected() {
        if (this.getTotalMutations() == 0L) {
            return 100L;
        }
        if (this.getTotalDetectedMutations() == 0L) {
            return 0L;
        }
        return Math.round(100.0f / (float)this.getTotalMutations() * (float)this.getTotalDetectedMutations());
    }

    private static F<StatusCount, Boolean> isDetected() {
        return new F<StatusCount, Boolean>(){

            @Override
            public Boolean apply(StatusCount a) {
                return a.getStatus().isDetected();
            }
        };
    }

    private F2<Long, StatusCount, Long> addTotals() {
        return new F2<Long, StatusCount, Long>(){

            @Override
            public Long apply(Long a, StatusCount b) {
                return a + b.getCount();
            }
        };
    }

    public void report(PrintStream out) {
        out.println("> " + this.mutatorName);
        out.println(">> Generated " + this.getTotalMutations() + " Killed " + this.getTotalDetectedMutations() + " (" + this.getPercentageDetected() + "%)");
        int i = 0;
        StringBuffer sb = new StringBuffer();
        for (StatusCount each : this.counts.values()) {
            sb.append(each + " ");
            if (++i % 4 != 0) continue;
            out.println("> " + sb.toString());
            sb = new StringBuffer();
        }
        out.println("> " + sb.toString());
    }

    public String getMutatorName() {
        return this.mutatorName;
    }
}

