/*
 * Decompiled with CFR 0.152.
 */
package org.pitest.mutationtest.tooling;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.Reader;
import java.util.Collection;
import org.pitest.functional.F;
import org.pitest.functional.FCollection;
import org.pitest.functional.FunctionalList;
import org.pitest.functional.Option;
import org.pitest.mutationtest.SourceLocator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DirectorySourceLocator
implements SourceLocator {
    private final File root;
    private final F<File, Option<Reader>> fileToReader;

    DirectorySourceLocator(File root, F<File, Option<Reader>> fileToReader) {
        this.root = root;
        this.fileToReader = fileToReader;
    }

    public DirectorySourceLocator(File root) {
        this(root, new FileToReader());
    }

    @Override
    public Option<Reader> locate(Collection<String> classes, String fileName) {
        FunctionalList<Reader> matches = FCollection.flatMap(classes, this.classNameToSourceFileReader(fileName));
        if (matches.isEmpty()) {
            return Option.none();
        }
        return Option.some(matches.iterator().next());
    }

    private F<String, Iterable<Reader>> classNameToSourceFileReader(final String fileName) {
        return new F<String, Iterable<Reader>>(){

            @Override
            public Iterable<Reader> apply(String className) {
                if (className.contains(".")) {
                    File f = new File(className.replace(".", File.separator));
                    return DirectorySourceLocator.this.locate(f.getParent() + File.separator + fileName);
                }
                return DirectorySourceLocator.this.locate(fileName);
            }
        };
    }

    private final Option<Reader> locate(String fileName) {
        File f = new File(this.root + File.separator + fileName);
        return this.fileToReader.apply(f);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class FileToReader
    implements F<File, Option<Reader>> {
        private FileToReader() {
        }

        @Override
        public Option<Reader> apply(File f) {
            if (f.exists()) {
                try {
                    return Option.some(new FileReader(f));
                }
                catch (FileNotFoundException e) {
                    return Option.none();
                }
            }
            return Option.none();
        }
    }
}

