/*
 * Decompiled with CFR 0.152.
 */
package org.pitest.mutationtest.tooling;

import java.io.File;
import java.io.IOException;
import java.io.PrintStream;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.Executors;
import java.util.logging.Logger;
import org.pitest.classinfo.ClassInfo;
import org.pitest.classinfo.ClassName;
import org.pitest.classinfo.HierarchicalClassId;
import org.pitest.classpath.ClassPathByteArraySource;
import org.pitest.classpath.CodeSource;
import org.pitest.coverage.CoverageDatabase;
import org.pitest.coverage.CoverageGenerator;
import org.pitest.coverage.TestInfo;
import org.pitest.execute.Container;
import org.pitest.execute.DefaultStaticConfig;
import org.pitest.execute.Pitest;
import org.pitest.execute.containers.BaseThreadPoolContainer;
import org.pitest.execute.containers.ClassLoaderFactory;
import org.pitest.execute.containers.UnContainer;
import org.pitest.functional.FCollection;
import org.pitest.functional.FunctionalList;
import org.pitest.functional.prelude.Prelude;
import org.pitest.help.Help;
import org.pitest.help.PitHelpError;
import org.pitest.mutationtest.HistoryStore;
import org.pitest.mutationtest.ListenerArguments;
import org.pitest.mutationtest.MutationConfig;
import org.pitest.mutationtest.MutationResultListener;
import org.pitest.mutationtest.build.MutationGrouper;
import org.pitest.mutationtest.build.MutationSource;
import org.pitest.mutationtest.build.MutationTestBuilder;
import org.pitest.mutationtest.build.PercentAndConstantTimeoutStrategy;
import org.pitest.mutationtest.build.TestPrioritiser;
import org.pitest.mutationtest.build.WorkerFactory;
import org.pitest.mutationtest.config.ReportOptions;
import org.pitest.mutationtest.config.SettingsFactory;
import org.pitest.mutationtest.engine.MutationEngine;
import org.pitest.mutationtest.filter.MutationFilterFactory;
import org.pitest.mutationtest.incremental.DefaultCodeHistory;
import org.pitest.mutationtest.incremental.HistoryListener;
import org.pitest.mutationtest.incremental.IncrementalAnalyser;
import org.pitest.mutationtest.statistics.MutationStatisticsListener;
import org.pitest.mutationtest.statistics.Score;
import org.pitest.mutationtest.tooling.CombinedStatistics;
import org.pitest.mutationtest.tooling.MutationResultAdapter;
import org.pitest.mutationtest.tooling.MutationStrategies;
import org.pitest.mutationtest.tooling.SmartSourceLocator;
import org.pitest.mutationtest.tooling.SpinnerListener;
import org.pitest.testapi.TestUnit;
import org.pitest.util.IsolationUtils;
import org.pitest.util.Log;
import org.pitest.util.StringUtil;
import org.pitest.util.Timings;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MutationCoverage {
    private static final int MB = 0x100000;
    private static final Logger LOG = Log.getLogger();
    private final ReportOptions data;
    private final MutationStrategies strategies;
    private final Timings timings;
    private final CodeSource code;
    private final File baseDir;
    private final SettingsFactory settings;

    public MutationCoverage(MutationStrategies strategies, File baseDir, CodeSource code, ReportOptions data, SettingsFactory settings, Timings timings) {
        this.strategies = strategies;
        this.data = data;
        this.settings = settings;
        this.timings = timings;
        this.code = code;
        this.baseDir = baseDir;
    }

    public CombinedStatistics runReport() throws IOException {
        Log.setVerbose(this.data.isVerbose());
        Runtime runtime = Runtime.getRuntime();
        if (!this.data.isVerbose()) {
            LOG.info("Verbose logging is disabled. If you encounter an problem please enable it before reporting an issue.");
        }
        LOG.fine("Running report with " + this.data);
        LOG.fine("System class path is " + System.getProperty("java.class.path"));
        LOG.fine("Maximum available memory is " + runtime.maxMemory() / 0x100000L + " mb");
        long t0 = System.currentTimeMillis();
        this.verifyBuildSuitableForMutationTesting();
        CoverageDatabase coverageData = this.coverage().calculateCoverage();
        LOG.fine("Used memory after coverage calculation " + (runtime.totalMemory() - runtime.freeMemory()) / 0x100000L + " mb");
        LOG.fine("Free Memory after coverage calculation " + runtime.freeMemory() / 0x100000L + " mb");
        MutationStatisticsListener stats = new MutationStatisticsListener();
        MutationEngine engine = this.strategies.factory().createEngine(this.data.isMutateStaticInitializers(), Prelude.or(this.data.getExcludedMethods()), this.data.getLoggingClasses(), this.data.getMutators(), this.data.isDetectInlinedCode());
        DefaultStaticConfig staticConfig = this.createConfig(t0, coverageData, stats, engine);
        this.history().initialize();
        this.timings.registerStart(Timings.Stage.BUILD_MUTATION_TESTS);
        List<? extends TestUnit> tus = this.buildMutationTests(coverageData, engine);
        this.timings.registerEnd(Timings.Stage.BUILD_MUTATION_TESTS);
        LOG.info("Created  " + tus.size() + " mutation test units");
        this.checkMutationsFound(tus);
        this.recordClassPath(coverageData);
        LOG.fine("Used memory before analysis start " + (runtime.totalMemory() - runtime.freeMemory()) / 0x100000L + " mb");
        LOG.fine("Free Memory before analysis start " + runtime.freeMemory() / 0x100000L + " mb");
        Pitest pit = new Pitest(staticConfig);
        this.timings.registerStart(Timings.Stage.RUN_MUTATION_TESTS);
        pit.run(this.createContainer(), tus);
        this.timings.registerEnd(Timings.Stage.RUN_MUTATION_TESTS);
        LOG.info("Completed in " + this.timeSpan(t0));
        this.printStats(stats);
        return new CombinedStatistics(stats.getStatistics(), coverageData.createSummary());
    }

    private DefaultStaticConfig createConfig(long t0, CoverageDatabase coverageData, MutationStatisticsListener stats, MutationEngine engine) {
        DefaultStaticConfig staticConfig = new DefaultStaticConfig();
        staticConfig.addTestListener(MutationResultAdapter.adapt(stats));
        ListenerArguments args = new ListenerArguments(this.strategies.output(), coverageData, new SmartSourceLocator(this.data.getSourceDirs()), engine, t0);
        MutationResultListener mutationReportListener = this.strategies.listenerFactory().getListener(args);
        staticConfig.addTestListener(MutationResultAdapter.adapt(mutationReportListener));
        staticConfig.addTestListener(MutationResultAdapter.adapt(new HistoryListener(this.history())));
        if (!this.data.isVerbose()) {
            staticConfig.addTestListener(MutationResultAdapter.adapt(new SpinnerListener(System.out)));
        }
        return staticConfig;
    }

    private void recordClassPath(CoverageDatabase coverageData) {
        Set<ClassName> allClassNames = this.getAllClassesAndTests(coverageData);
        FunctionalList<HierarchicalClassId> ids = FCollection.map(this.code.getClassInfo(allClassNames), ClassInfo.toFullClassId());
        this.history().recordClassPath(ids, coverageData);
    }

    private Set<ClassName> getAllClassesAndTests(CoverageDatabase coverageData) {
        HashSet<ClassName> names = new HashSet<ClassName>();
        for (ClassName each : this.code.getCodeUnderTestNames()) {
            names.add(each);
            FCollection.mapTo(coverageData.getTestsForClass(each), TestInfo.toDefiningClassName(), names);
        }
        return names;
    }

    private void verifyBuildSuitableForMutationTesting() {
        this.strategies.buildVerifier().verify(this.code);
    }

    private void printStats(MutationStatisticsListener stats) {
        PrintStream ps = System.out;
        ps.println(StringUtil.separatorLine('='));
        ps.println("- Timings");
        ps.println(StringUtil.separatorLine('='));
        this.timings.report(ps);
        ps.println(StringUtil.separatorLine('='));
        ps.println("- Statistics");
        ps.println(StringUtil.separatorLine('='));
        stats.getStatistics().report(ps);
        ps.println(StringUtil.separatorLine('='));
        ps.println("- Mutators");
        ps.println(StringUtil.separatorLine('='));
        for (Score each : stats.getStatistics().getScores()) {
            each.report(ps);
            ps.println(StringUtil.separatorLine());
        }
    }

    private List<? extends TestUnit> buildMutationTests(CoverageDatabase coverageData, MutationEngine engine) {
        MutationConfig mutationConfig = new MutationConfig(engine, this.coverage().getLaunchOptions());
        ClassPathByteArraySource bas = new ClassPathByteArraySource(this.data.getClassPath());
        TestPrioritiser testPrioritiser = this.settings.getTestPrioritiser().makeTestPrioritiser(this.code, coverageData);
        MutationSource source = new MutationSource(mutationConfig, this.makeFilter().createFilter(this.code, this.data.getMaxMutationsPerClass()), testPrioritiser, bas);
        IncrementalAnalyser analyser = new IncrementalAnalyser(new DefaultCodeHistory(this.code, this.history()), coverageData);
        WorkerFactory wf = new WorkerFactory(this.baseDir, this.coverage().getConfiguration(), mutationConfig, new PercentAndConstantTimeoutStrategy(this.data.getTimeoutFactor(), this.data.getTimeoutConstant()), this.data.isVerbose(), this.data.getClassPath().getLocalClassPath());
        MutationGrouper grouper = this.settings.getMutationGrouper().makeFactory(this.code, this.data.getNumberOfThreads(), this.data.getMutationUnitSize());
        MutationTestBuilder builder = new MutationTestBuilder(wf, mutationConfig, analyser, source, grouper);
        return builder.createMutationTestUnits(this.code.getCodeUnderTestNames());
    }

    private MutationFilterFactory makeFilter() {
        return this.settings.createMutationFilter();
    }

    private void checkMutationsFound(List<? extends TestUnit> tus) {
        if (tus.isEmpty()) {
            if (this.data.shouldFailWhenNoMutations()) {
                throw new PitHelpError(Help.NO_MUTATIONS_FOUND, new Object[0]);
            }
            LOG.warning(Help.NO_MUTATIONS_FOUND.toString());
        }
    }

    private Container createContainer() {
        if (this.data.getNumberOfThreads() > 1) {
            return new BaseThreadPoolContainer(this.data.getNumberOfThreads(), this.classLoaderFactory(), Executors.defaultThreadFactory()){};
        }
        return new UnContainer();
    }

    private ClassLoaderFactory classLoaderFactory() {
        final ClassLoader loader = IsolationUtils.getContextClassLoader();
        return new ClassLoaderFactory(){

            public ClassLoader get() {
                return loader;
            }
        };
    }

    private String timeSpan(long t0) {
        return "" + (System.currentTimeMillis() - t0) / 1000L + " seconds";
    }

    private CoverageGenerator coverage() {
        return this.strategies.coverage();
    }

    private HistoryStore history() {
        return this.strategies.history();
    }
}

