/*
 * Decompiled with CFR 0.152.
 */
package org.pitest.mutationtest.tooling;

import org.pitest.functional.Option;
import org.pitest.mutationtest.ClassMutationResults;
import org.pitest.mutationtest.MutationMetaData;
import org.pitest.mutationtest.MutationResultListener;
import org.pitest.testapi.Description;
import org.pitest.testapi.TestListener;
import org.pitest.testapi.TestResult;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MutationResultAdapter
implements TestListener {
    private final MutationResultListener child;

    public MutationResultAdapter(MutationResultListener child) {
        this.child = child;
    }

    public static TestListener adapt(MutationResultListener child) {
        return new MutationResultAdapter(child);
    }

    @Override
    public void onRunStart() {
        this.child.runStart();
    }

    @Override
    public void onTestStart(Description d) {
    }

    @Override
    public void onTestFailure(TestResult tr) {
        this.extractMutationData(tr);
    }

    @Override
    public void onTestError(TestResult tr) {
        this.extractMutationData(tr);
    }

    @Override
    public void onTestSkipped(TestResult tr) {
    }

    @Override
    public void onTestSuccess(TestResult tr) {
        this.extractMutationData(tr);
    }

    @Override
    public void onRunEnd() {
        this.child.runEnd();
    }

    private void extractMutationData(TestResult tr) {
        for (MutationMetaData metaData : this.extractMetaData(tr)) {
            for (ClassMutationResults cr : metaData.toClassResults()) {
                this.child.handleMutationResult(cr);
            }
        }
    }

    private Option<MutationMetaData> extractMetaData(TestResult tr) {
        return tr.getValue(MutationMetaData.class);
    }
}

