/*
 * Decompiled with CFR 0.152.
 */
package org.pitest.mutationtest.tooling;

import java.io.File;
import java.io.Reader;
import java.util.Collection;
import org.pitest.functional.F;
import org.pitest.functional.FArray;
import org.pitest.functional.FCollection;
import org.pitest.functional.FunctionalList;
import org.pitest.functional.Option;
import org.pitest.mutationtest.SourceLocator;
import org.pitest.mutationtest.tooling.DirectorySourceLocator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SmartSourceLocator
implements SourceLocator {
    private static final int MAX_DEPTH = 4;
    private final Collection<SourceLocator> children;

    public SmartSourceLocator(Collection<File> roots) {
        FunctionalList<File> childDirs = FCollection.flatMap(roots, this.collectChildren(0));
        childDirs.addAll(roots);
        F<File, SourceLocator> fileToSourceLocator = new F<File, SourceLocator>(){

            @Override
            public SourceLocator apply(File a) {
                return new DirectorySourceLocator(a);
            }
        };
        this.children = FCollection.map(childDirs, fileToSourceLocator);
    }

    private F<File, Collection<File>> collectChildren(final int depth) {
        return new F<File, Collection<File>>(){

            @Override
            public Collection<File> apply(File a) {
                return SmartSourceLocator.this.collectDirectories(a, depth);
            }
        };
    }

    private Collection<File> collectDirectories(File root, int depth) {
        Collection<File> childDirs = SmartSourceLocator.listFirstLevelDirectories(root);
        if (depth < 4) {
            childDirs.addAll(FCollection.flatMap(childDirs, this.collectChildren(depth + 1)));
        }
        return childDirs;
    }

    private static Collection<File> listFirstLevelDirectories(File root) {
        F<File, Boolean> p = new F<File, Boolean>(){

            @Override
            public Boolean apply(File a) {
                return a.isDirectory();
            }
        };
        return FArray.filter(root.listFiles(), p);
    }

    @Override
    public Option<Reader> locate(Collection<String> classes, String fileName) {
        for (SourceLocator each : this.children) {
            Option<Reader> reader = each.locate(classes, fileName);
            if (!reader.hasSome()) continue;
            return reader;
        }
        return Option.none();
    }
}

