/*
 * Decompiled with CFR 0.152.
 */
package org.pitest.mutationtest.verify;

import java.util.Collection;
import org.pitest.classinfo.ClassInfo;
import org.pitest.classpath.CodeSource;
import org.pitest.functional.F;
import org.pitest.functional.FCollection;
import org.pitest.functional.SideEffect1;
import org.pitest.help.Help;
import org.pitest.help.PitHelpError;
import org.pitest.mutationtest.verify.BuildVerifier;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultBuildVerifier
implements BuildVerifier {
    @Override
    public void verify(CodeSource code) {
        Collection<ClassInfo> codeClasses = code.getCode();
        this.checkAtLeastOneClassHasLineNumbers(codeClasses);
        FCollection.forEach(codeClasses, this.throwErrorIfHasNoSourceFile());
    }

    private void checkAtLeastOneClassHasLineNumbers(Collection<ClassInfo> codeClasses) {
        if (!FCollection.contains(codeClasses, DefaultBuildVerifier.aClassWithLineNumbers()) && !codeClasses.isEmpty()) {
            throw new PitHelpError(Help.NO_LINE_NUMBERS, new Object[0]);
        }
    }

    private static F<ClassInfo, Boolean> aClassWithLineNumbers() {
        return new F<ClassInfo, Boolean>(){

            @Override
            public Boolean apply(ClassInfo a) {
                return a.getNumberOfCodeLines() != 0;
            }
        };
    }

    private SideEffect1<ClassInfo> throwErrorIfHasNoSourceFile() {
        return new SideEffect1<ClassInfo>(){

            @Override
            public void apply(ClassInfo a) {
                if (a.getSourceFileName() == null) {
                    throw new PitHelpError(Help.NO_SOURCE_FILE, a.getName().asJavaName());
                }
            }
        };
    }
}

