/*
 * Decompiled with CFR 0.152.
 */
package org.pitest.process;

import java.io.File;
import java.io.IOException;
import java.lang.management.ManagementFactory;
import java.lang.management.RuntimeMXBean;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.pitest.functional.FCollection;
import org.pitest.functional.FunctionalList;
import org.pitest.functional.Option;
import org.pitest.functional.SideEffect1;
import org.pitest.functional.predicate.Predicate;
import org.pitest.functional.prelude.Prelude;
import org.pitest.process.JavaAgent;
import org.pitest.util.Monitor;
import org.pitest.util.StreamMonitor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JavaProcess {
    private final Process process;
    private final Monitor out;
    private final Monitor err;

    public JavaProcess(Process process, SideEffect1<String> sysoutHandler, SideEffect1<String> syserrHandler) {
        this.process = process;
        this.out = new StreamMonitor(process.getInputStream(), sysoutHandler);
        this.err = new StreamMonitor(process.getErrorStream(), syserrHandler);
        this.out.requestStart();
        this.err.requestStart();
    }

    public void destroy() {
        this.out.requestStop();
        this.err.requestStop();
        this.process.destroy();
    }

    public int waitToDie() throws InterruptedException {
        int exitVal = this.process.waitFor();
        this.out.requestStop();
        this.err.requestStop();
        return exitVal;
    }

    public boolean isAlive() {
        try {
            this.process.exitValue();
            return false;
        }
        catch (IllegalThreadStateException e) {
            return true;
        }
    }

    private static List<String> createLaunchArgs(String javaProcess, JavaAgent agentJarLocator, List<String> args, Class<?> mainClass, List<String> programArgs) {
        ArrayList<String> cmd = new ArrayList<String>();
        cmd.add(javaProcess);
        cmd.addAll(args);
        JavaProcess.addPITJavaAgent(agentJarLocator, cmd);
        JavaProcess.addLaunchJavaAgents(cmd);
        cmd.add(mainClass.getName());
        cmd.addAll(programArgs);
        return cmd;
    }

    private static void addPITJavaAgent(JavaAgent agentJarLocator, List<String> cmd) {
        Option<String> jarLocation = agentJarLocator.getJarLocation();
        for (String each : jarLocation) {
            cmd.add("-javaagent:" + each);
        }
    }

    private static void addLaunchJavaAgents(List<String> cmd) {
        RuntimeMXBean rt = ManagementFactory.getRuntimeMXBean();
        FunctionalList<String> agents = FCollection.filter(rt.getInputArguments(), Prelude.or(JavaProcess.isJavaAgentParam(), JavaProcess.isEnvironmentSetting()));
        cmd.addAll(agents);
    }

    private static Predicate<String> isEnvironmentSetting() {
        return new Predicate<String>(){

            @Override
            public Boolean apply(String a) {
                return a.startsWith("-D");
            }
        };
    }

    private static Predicate<String> isJavaAgentParam() {
        return new Predicate<String>(){

            @Override
            public Boolean apply(String a) {
                return a.toLowerCase().startsWith("-javaagent");
            }
        };
    }

    public static JavaProcess launch(File workingDirectory, String javaProc, SideEffect1<String> systemOutHandler, SideEffect1<String> sysErrHandler, List<String> args, Class<?> mainClass, List<String> programArgs, JavaAgent javaAgent, String initialClassPath) throws IOException {
        List<String> cmd = JavaProcess.createLaunchArgs(javaProc, javaAgent, args, mainClass, programArgs);
        ProcessBuilder processBuilder = new ProcessBuilder(cmd);
        processBuilder.directory(workingDirectory);
        Map<String, String> env = processBuilder.environment();
        env.put("CLASSPATH", initialClassPath);
        Process process = processBuilder.start();
        return new JavaProcess(process, systemOutHandler, sysErrHandler);
    }
}

