/*
 * Decompiled with CFR 0.152.
 */
package org.pitest.process;

import java.io.File;
import java.util.Collections;
import java.util.List;
import org.pitest.classpath.ClassPath;
import org.pitest.functional.SideEffect1;
import org.pitest.functional.prelude.Prelude;
import org.pitest.process.JavaAgent;
import org.pitest.process.LaunchOptions;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class ProcessArgs {
    private final String launchClassPath;
    private SideEffect1<String> stdout = Prelude.print(String.class);
    private SideEffect1<String> stdErr = Prelude.printTo(String.class, System.err);
    private List<String> jvmArgs = Collections.emptyList();
    private JavaAgent javaAgentFinder;
    private File workingDir = null;
    private String javaExecutable;

    private ProcessArgs(String launchClassPath) {
        this.launchClassPath = launchClassPath;
    }

    public static ProcessArgs withClassPath(String cp) {
        return new ProcessArgs(cp);
    }

    public static ProcessArgs withClassPath(ClassPath cp) {
        return new ProcessArgs(cp.getLocalClassPath());
    }

    public ProcessArgs andBaseDir(File baseDir) {
        this.workingDir = baseDir;
        return this;
    }

    public ProcessArgs andStdout(SideEffect1<String> stdout) {
        this.stdout = stdout;
        return this;
    }

    public ProcessArgs andStderr(SideEffect1<String> stderr) {
        this.stdErr = stderr;
        return this;
    }

    public String getLaunchClassPath() {
        return this.launchClassPath;
    }

    public SideEffect1<String> getStdout() {
        return this.stdout;
    }

    public SideEffect1<String> getStdErr() {
        return this.stdErr;
    }

    public List<String> getJvmArgs() {
        return this.jvmArgs;
    }

    public JavaAgent getJavaAgentFinder() {
        return this.javaAgentFinder;
    }

    public void setStdout(SideEffect1<String> stdout) {
        this.stdout = stdout;
    }

    public void setStdErr(SideEffect1<String> stdErr) {
        this.stdErr = stdErr;
    }

    public void setJvmArgs(List<String> jvmArgs) {
        this.jvmArgs = jvmArgs;
    }

    public File getWorkingDir() {
        return this.workingDir;
    }

    public String getJavaExecutable() {
        return this.javaExecutable;
    }

    public ProcessArgs andLaunchOptions(LaunchOptions launchOptions) {
        this.jvmArgs = launchOptions.getChildJVMArgs();
        this.javaAgentFinder = launchOptions.getJavaAgentFinder();
        this.javaExecutable = launchOptions.getJavaExecutable();
        return this;
    }
}

