/*
 * Decompiled with CFR 0.152.
 */
package org.pitest.project;

import org.pitest.project.ProjectConfigurationParser;
import org.pitest.project.ProjectConfigurationParserException;

public class ProjectConfigurationParserFactory {
    public static final String PARSER_PROPERTY = "projectConfigurationParser.impl";

    public static ProjectConfigurationParser createParser() throws ProjectConfigurationParserException {
        try {
            String propertyValue = System.getProperty(PARSER_PROPERTY);
            if (propertyValue == null) {
                throw new ProjectConfigurationParserException("No parser implementation set");
            }
            Class<?> parserClass = Class.forName(propertyValue);
            Object instance = parserClass.newInstance();
            if (instance instanceof ProjectConfigurationParser) {
                return (ProjectConfigurationParser)instance;
            }
            throw new ProjectConfigurationParserException("Cannot create ProjectConfigurationParser instance from class " + propertyValue + " as it does not implement " + ProjectConfigurationParser.class.getName() + ".");
        }
        catch (ClassNotFoundException e) {
            throw new ProjectConfigurationParserException(e);
        }
        catch (InstantiationException e) {
            throw new ProjectConfigurationParserException(e);
        }
        catch (IllegalAccessException e) {
            throw new ProjectConfigurationParserException(e);
        }
    }
}

