/*
 * Decompiled with CFR 0.152.
 */
package org.pitest.reflection;

import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import org.pitest.functional.FArray;
import org.pitest.functional.predicate.Predicate;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class Reflection {
    public static Method publicMethod(Class<?> clazz, Predicate<Method> p) {
        return Reflection.publicMethods(clazz, p).iterator().next();
    }

    public static Set<Method> publicMethods(Class<?> clazz, Predicate<Method> p) {
        LinkedHashSet<Method> ms = new LinkedHashSet<Method>();
        FArray.filter(clazz.getMethods(), p, ms);
        return ms;
    }

    public static Set<Method> allMethods(Class<?> c) {
        LinkedHashSet<Method> methods = new LinkedHashSet<Method>();
        if (c != null) {
            List<Method> locallyDeclaredMethods = Arrays.asList(c.getDeclaredMethods());
            methods.addAll(locallyDeclaredMethods);
            methods.addAll(Reflection.allMethods(c.getSuperclass()));
        }
        return methods;
    }

    public static Method publicMethod(Class<? extends Object> clazz, final String name) {
        Predicate<Method> p = new Predicate<Method>(){

            @Override
            public Boolean apply(Method a) {
                return a.getName().equals(name);
            }
        };
        return Reflection.publicMethod(clazz, p);
    }
}

