/*
 * Decompiled with CFR 0.152.
 */
package org.pitest.reloc.xstream.converters.collections;

import java.lang.reflect.Field;
import java.util.Map;
import java.util.Properties;
import java.util.TreeMap;
import org.pitest.reloc.xstream.converters.Converter;
import org.pitest.reloc.xstream.converters.MarshallingContext;
import org.pitest.reloc.xstream.converters.UnmarshallingContext;
import org.pitest.reloc.xstream.core.util.Fields;
import org.pitest.reloc.xstream.io.HierarchicalStreamReader;
import org.pitest.reloc.xstream.io.HierarchicalStreamWriter;

public class PropertiesConverter
implements Converter {
    private static final Field defaultsField;
    private final boolean sort;

    public PropertiesConverter() {
        this(false);
    }

    public PropertiesConverter(boolean sort) {
        this.sort = sort;
    }

    public boolean canConvert(Class type) {
        return Properties.class == type;
    }

    public void marshal(Object source, HierarchicalStreamWriter writer, MarshallingContext context) {
        Properties defaults;
        Properties properties = (Properties)source;
        Map<Object, Object> map = this.sort ? new TreeMap<Object, Object>(properties) : properties;
        for (Map.Entry<Object, Object> entry : map.entrySet()) {
            writer.startNode("property");
            writer.addAttribute("name", entry.getKey().toString());
            writer.addAttribute("value", entry.getValue().toString());
            writer.endNode();
        }
        if (defaultsField != null && (defaults = (Properties)Fields.read(defaultsField, properties)) != null) {
            writer.startNode("defaults");
            this.marshal(defaults, writer, context);
            writer.endNode();
        }
    }

    public Object unmarshal(HierarchicalStreamReader reader, UnmarshallingContext context) {
        Properties properties = new Properties();
        Properties defaults = null;
        while (reader.hasMoreChildren()) {
            reader.moveDown();
            if (reader.getNodeName().equals("defaults")) {
                defaults = (Properties)this.unmarshal(reader, context);
            } else {
                String name = reader.getAttribute("name");
                String value = reader.getAttribute("value");
                properties.setProperty(name, value);
            }
            reader.moveUp();
        }
        if (defaults == null) {
            return properties;
        }
        Properties propertiesWithDefaults = new Properties(defaults);
        propertiesWithDefaults.putAll((Map<?, ?>)properties);
        return propertiesWithDefaults;
    }

    static {
        Field field = null;
        try {
            field = Fields.find(Properties.class, "defaults");
        }
        catch (SecurityException ex) {
        }
        catch (RuntimeException ex) {
            throw new ExceptionInInitializerError("No field 'defaults' in type Properties found");
        }
        defaultsField = field;
    }
}

