/*
 * Decompiled with CFR 0.152.
 */
package org.pitest.reloc.xstream.converters.collections;

import java.util.Collections;
import org.pitest.reloc.xstream.converters.UnmarshallingContext;
import org.pitest.reloc.xstream.converters.collections.CollectionConverter;
import org.pitest.reloc.xstream.io.HierarchicalStreamReader;
import org.pitest.reloc.xstream.mapper.Mapper;

public class SingletonCollectionConverter
extends CollectionConverter {
    private static final Class LIST = Collections.singletonList(Boolean.TRUE).getClass();
    private static final Class SET = Collections.singleton(Boolean.TRUE).getClass();

    public SingletonCollectionConverter(Mapper mapper) {
        super(mapper);
    }

    public boolean canConvert(Class type) {
        return LIST == type || SET == type;
    }

    public Object unmarshal(HierarchicalStreamReader reader, UnmarshallingContext context) {
        reader.moveDown();
        Object item = this.readItem(reader, context, null);
        reader.moveUp();
        return context.getRequiredType() == LIST ? Collections.singletonList(item) : Collections.singleton(item);
    }
}

