/*
 * Decompiled with CFR 0.152.
 */
package org.pitest.reloc.xstream.converters.collections;

import java.util.Collections;
import org.pitest.reloc.xstream.converters.UnmarshallingContext;
import org.pitest.reloc.xstream.converters.collections.MapConverter;
import org.pitest.reloc.xstream.io.HierarchicalStreamReader;
import org.pitest.reloc.xstream.mapper.Mapper;

public class SingletonMapConverter
extends MapConverter {
    private static final Class MAP = Collections.singletonMap(Boolean.TRUE, null).getClass();

    public SingletonMapConverter(Mapper mapper) {
        super(mapper);
    }

    public boolean canConvert(Class type) {
        return MAP == type;
    }

    public Object unmarshal(HierarchicalStreamReader reader, UnmarshallingContext context) {
        reader.moveDown();
        reader.moveDown();
        Object key = this.readItem(reader, context, null);
        reader.moveUp();
        reader.moveDown();
        Object value = this.readItem(reader, context, null);
        reader.moveUp();
        reader.moveUp();
        return Collections.singletonMap(key, value);
    }
}

