/*
 * Decompiled with CFR 0.152.
 */
package org.pitest.reloc.xstream.converters.extended;

import java.awt.Color;
import java.util.HashMap;
import org.pitest.reloc.xstream.converters.Converter;
import org.pitest.reloc.xstream.converters.MarshallingContext;
import org.pitest.reloc.xstream.converters.UnmarshallingContext;
import org.pitest.reloc.xstream.io.ExtendedHierarchicalStreamWriterHelper;
import org.pitest.reloc.xstream.io.HierarchicalStreamReader;
import org.pitest.reloc.xstream.io.HierarchicalStreamWriter;

public class ColorConverter
implements Converter {
    public boolean canConvert(Class type) {
        return type.getName().equals("java.awt.Color");
    }

    public void marshal(Object source, HierarchicalStreamWriter writer, MarshallingContext context) {
        Color color = (Color)source;
        this.write("red", color.getRed(), writer);
        this.write("green", color.getGreen(), writer);
        this.write("blue", color.getBlue(), writer);
        this.write("alpha", color.getAlpha(), writer);
    }

    public Object unmarshal(HierarchicalStreamReader reader, UnmarshallingContext context) {
        HashMap<String, Integer> elements = new HashMap<String, Integer>();
        while (reader.hasMoreChildren()) {
            reader.moveDown();
            elements.put(reader.getNodeName(), Integer.valueOf(reader.getValue()));
            reader.moveUp();
        }
        return new Color((Integer)elements.get("red"), (Integer)elements.get("green"), (Integer)elements.get("blue"), (Integer)elements.get("alpha"));
    }

    private void write(String fieldName, int value, HierarchicalStreamWriter writer) {
        ExtendedHierarchicalStreamWriterHelper.startNode(writer, fieldName, Integer.TYPE);
        writer.setValue(String.valueOf(value));
        writer.endNode();
    }
}

