/*
 * Decompiled with CFR 0.152.
 */
package org.pitest.reloc.xstream.converters.extended;

import java.lang.reflect.Field;
import org.pitest.reloc.xstream.converters.ConversionException;
import org.pitest.reloc.xstream.converters.Converter;
import org.pitest.reloc.xstream.converters.MarshallingContext;
import org.pitest.reloc.xstream.converters.SingleValueConverter;
import org.pitest.reloc.xstream.converters.UnmarshallingContext;
import org.pitest.reloc.xstream.converters.extended.JavaClassConverter;
import org.pitest.reloc.xstream.io.HierarchicalStreamReader;
import org.pitest.reloc.xstream.io.HierarchicalStreamWriter;

public class JavaFieldConverter
implements Converter {
    private final SingleValueConverter javaClassConverter;

    public JavaFieldConverter(ClassLoader classLoader) {
        this.javaClassConverter = new JavaClassConverter(classLoader);
    }

    public boolean canConvert(Class type) {
        return type.equals(Field.class);
    }

    public void marshal(Object source, HierarchicalStreamWriter writer, MarshallingContext context) {
        Field field = (Field)source;
        writer.startNode("name");
        writer.setValue(field.getName());
        writer.endNode();
        writer.startNode("clazz");
        writer.setValue(this.javaClassConverter.toString(field.getDeclaringClass()));
        writer.endNode();
    }

    public Object unmarshal(HierarchicalStreamReader reader, UnmarshallingContext context) {
        String methodName = null;
        String declaringClassName = null;
        while ((methodName == null || declaringClassName == null) && reader.hasMoreChildren()) {
            reader.moveDown();
            if (reader.getNodeName().equals("name")) {
                methodName = reader.getValue();
            } else if (reader.getNodeName().equals("clazz")) {
                declaringClassName = reader.getValue();
            }
            reader.moveUp();
        }
        Class declaringClass = (Class)this.javaClassConverter.fromString(declaringClassName);
        try {
            return declaringClass.getDeclaredField(methodName);
        }
        catch (NoSuchFieldException e) {
            throw new ConversionException(e);
        }
    }
}

