/*
 * Decompiled with CFR 0.152.
 */
package org.pitest.reloc.xstream.converters.javabean;

import java.util.HashSet;
import org.pitest.reloc.xstream.converters.ConversionException;
import org.pitest.reloc.xstream.converters.Converter;
import org.pitest.reloc.xstream.converters.MarshallingContext;
import org.pitest.reloc.xstream.converters.UnmarshallingContext;
import org.pitest.reloc.xstream.converters.javabean.BeanProvider;
import org.pitest.reloc.xstream.converters.javabean.JavaBeanProvider;
import org.pitest.reloc.xstream.converters.reflection.MissingFieldException;
import org.pitest.reloc.xstream.core.util.FastField;
import org.pitest.reloc.xstream.io.ExtendedHierarchicalStreamWriterHelper;
import org.pitest.reloc.xstream.io.HierarchicalStreamReader;
import org.pitest.reloc.xstream.io.HierarchicalStreamWriter;
import org.pitest.reloc.xstream.mapper.Mapper;

public class JavaBeanConverter
implements Converter {
    protected final Mapper mapper;
    protected final JavaBeanProvider beanProvider;
    private String classAttributeIdentifier;

    public JavaBeanConverter(Mapper mapper) {
        this(mapper, new BeanProvider());
    }

    public JavaBeanConverter(Mapper mapper, JavaBeanProvider beanProvider) {
        this.mapper = mapper;
        this.beanProvider = beanProvider;
    }

    public JavaBeanConverter(Mapper mapper, String classAttributeIdentifier) {
        this(mapper, new BeanProvider());
        this.classAttributeIdentifier = classAttributeIdentifier;
    }

    public boolean canConvert(Class type) {
        return this.beanProvider.canInstantiate(type);
    }

    public void marshal(final Object source, final HierarchicalStreamWriter writer, final MarshallingContext context) {
        final String classAttributeName = this.classAttributeIdentifier != null ? this.classAttributeIdentifier : this.mapper.aliasForSystemAttribute("class");
        this.beanProvider.visitSerializableProperties(source, new JavaBeanProvider.Visitor(){

            public boolean shouldVisit(String name, Class definedIn) {
                return JavaBeanConverter.this.mapper.shouldSerializeMember(definedIn, name);
            }

            public void visit(String propertyName, Class fieldType, Class definedIn, Object newObj) {
                if (newObj != null) {
                    this.writeField(propertyName, fieldType, newObj, definedIn);
                }
            }

            private void writeField(String propertyName, Class fieldType, Object newObj, Class definedIn) {
                String serializedMember = JavaBeanConverter.this.mapper.serializedMember(source.getClass(), propertyName);
                ExtendedHierarchicalStreamWriterHelper.startNode(writer, serializedMember, fieldType);
                Class<?> actualType = newObj.getClass();
                Class defaultType = JavaBeanConverter.this.mapper.defaultImplementationOf(fieldType);
                if (!actualType.equals(defaultType) && classAttributeName != null) {
                    writer.addAttribute(classAttributeName, JavaBeanConverter.this.mapper.serializedClass(actualType));
                }
                context.convertAnother(newObj);
                writer.endNode();
            }
        });
    }

    public Object unmarshal(HierarchicalStreamReader reader, UnmarshallingContext context) {
        Object result = this.instantiateNewInstance(context);
        HashSet seenProperties = new HashSet(){

            public boolean add(Object e) {
                if (!super.add(e)) {
                    throw new DuplicatePropertyException(((FastField)e).getName());
                }
                return true;
            }
        };
        Class<?> resultType = result.getClass();
        while (reader.hasMoreChildren()) {
            reader.moveDown();
            String propertyName = this.mapper.realMember(resultType, reader.getNodeName());
            if (this.mapper.shouldSerializeMember(resultType, propertyName)) {
                boolean propertyExistsInClass = this.beanProvider.propertyDefinedInClass(propertyName, resultType);
                if (propertyExistsInClass) {
                    Class type = this.determineType(reader, result, propertyName);
                    Object value = context.convertAnother(result, type);
                    this.beanProvider.writeProperty(result, propertyName, value);
                    seenProperties.add(new FastField(resultType, propertyName));
                } else {
                    throw new MissingFieldException(resultType.getName(), propertyName);
                }
            }
            reader.moveUp();
        }
        return result;
    }

    private Object instantiateNewInstance(UnmarshallingContext context) {
        Object result = context.currentObject();
        if (result == null) {
            result = this.beanProvider.newInstance(context.getRequiredType());
        }
        return result;
    }

    private Class determineType(HierarchicalStreamReader reader, Object result, String fieldName) {
        String classAttribute;
        String classAttributeName = this.classAttributeIdentifier != null ? this.classAttributeIdentifier : this.mapper.aliasForSystemAttribute("class");
        String string = classAttribute = classAttributeName == null ? null : reader.getAttribute(classAttributeName);
        if (classAttribute != null) {
            return this.mapper.realClass(classAttribute);
        }
        return this.mapper.defaultImplementationOf(this.beanProvider.getPropertyType(result, fieldName));
    }

    public static class DuplicatePropertyException
    extends ConversionException {
        public DuplicatePropertyException(String msg) {
            super("Duplicate property " + msg);
            this.add("property", msg);
        }
    }

    public static class DuplicateFieldException
    extends ConversionException {
        public DuplicateFieldException(String msg) {
            super(msg);
        }
    }
}

