/*
 * Decompiled with CFR 0.152.
 */
package org.pitest.reloc.xstream.converters.reflection;

import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.pitest.reloc.xstream.converters.reflection.FieldKey;
import org.pitest.reloc.xstream.converters.reflection.FieldKeySorter;
import org.pitest.reloc.xstream.converters.reflection.ImmutableFieldKeySorter;
import org.pitest.reloc.xstream.converters.reflection.MissingFieldException;
import org.pitest.reloc.xstream.core.Caching;
import org.pitest.reloc.xstream.core.JVM;
import org.pitest.reloc.xstream.core.util.OrderRetainingMap;

public class FieldDictionary
implements Caching {
    private transient Map keyedByFieldNameCache;
    private transient Map keyedByFieldKeyCache;
    private final FieldKeySorter sorter;

    public FieldDictionary() {
        this(new ImmutableFieldKeySorter());
    }

    public FieldDictionary(FieldKeySorter sorter) {
        this.sorter = sorter;
        this.init();
    }

    private void init() {
        this.keyedByFieldNameCache = new HashMap();
        this.keyedByFieldKeyCache = new HashMap();
        this.keyedByFieldNameCache.put(Object.class, Collections.EMPTY_MAP);
        this.keyedByFieldKeyCache.put(Object.class, Collections.EMPTY_MAP);
    }

    public Iterator serializableFieldsFor(Class cls) {
        return this.fieldsFor(cls);
    }

    public Iterator fieldsFor(Class cls) {
        return this.buildMap(cls, true).values().iterator();
    }

    public Field field(Class cls, String name, Class definedIn) {
        Field field = this.fieldOrNull(cls, name, definedIn);
        if (field == null) {
            throw new MissingFieldException(cls.getName(), name);
        }
        return field;
    }

    public Field fieldOrNull(Class cls, String name, Class definedIn) {
        Map fields = this.buildMap(cls, definedIn != null);
        Field field = (Field)fields.get(definedIn != null ? new FieldKey(name, definedIn, 0) : name);
        return field;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Map buildMap(Class type, boolean tupleKeyed) {
        Map result;
        Class cls2 = type;
        FieldDictionary fieldDictionary = this;
        synchronized (fieldDictionary) {
            if (!this.keyedByFieldNameCache.containsKey(type)) {
                ArrayList<Class> superClasses = new ArrayList<Class>();
                while (!Object.class.equals((Object)cls2)) {
                    superClasses.add(0, cls2);
                    cls2 = cls2.getSuperclass();
                }
                HashMap<String, Field> lastKeyedByFieldName = Collections.EMPTY_MAP;
                Map<Object, Object> lastKeyedByFieldKey = Collections.EMPTY_MAP;
                for (Class cls2 : superClasses) {
                    if (!this.keyedByFieldNameCache.containsKey(cls2)) {
                        int i;
                        HashMap<String, Field> keyedByFieldName = new HashMap<String, Field>(lastKeyedByFieldName);
                        OrderRetainingMap keyedByFieldKey = new OrderRetainingMap(lastKeyedByFieldKey);
                        Field[] fields = cls2.getDeclaredFields();
                        if (JVM.reverseFieldDefinition()) {
                            i = fields.length >> 1;
                            while (i-- > 0) {
                                int idx = fields.length - i - 1;
                                Field field = fields[i];
                                fields[i] = fields[idx];
                                fields[idx] = field;
                            }
                        }
                        for (i = 0; i < fields.length; ++i) {
                            Field field = fields[i];
                            if (!field.isAccessible()) {
                                field.setAccessible(true);
                            }
                            FieldKey fieldKey = new FieldKey(field.getName(), field.getDeclaringClass(), i);
                            Field existent = (Field)keyedByFieldName.get(field.getName());
                            if (existent == null || (existent.getModifiers() & 8) != 0 || existent != null && (field.getModifiers() & 8) == 0) {
                                keyedByFieldName.put(field.getName(), field);
                            }
                            keyedByFieldKey.put(fieldKey, field);
                        }
                        Map sortedFieldKeys = this.sorter.sort(type, keyedByFieldKey);
                        this.keyedByFieldNameCache.put(cls2, keyedByFieldName);
                        this.keyedByFieldKeyCache.put(cls2, sortedFieldKeys);
                        lastKeyedByFieldName = keyedByFieldName;
                        lastKeyedByFieldKey = sortedFieldKeys;
                        continue;
                    }
                    lastKeyedByFieldName = (Map)this.keyedByFieldNameCache.get(cls2);
                    lastKeyedByFieldKey = (Map)this.keyedByFieldKeyCache.get(cls2);
                }
                result = tupleKeyed ? lastKeyedByFieldKey : lastKeyedByFieldName;
            } else {
                result = (Map)(tupleKeyed ? this.keyedByFieldKeyCache.get(type) : this.keyedByFieldNameCache.get(type));
            }
        }
        return result;
    }

    public synchronized void flushCache() {
        Set<Class<Object>> objectTypeSet = Collections.singleton(Object.class);
        this.keyedByFieldNameCache.keySet().retainAll(objectTypeSet);
        this.keyedByFieldKeyCache.keySet().retainAll(objectTypeSet);
        if (this.sorter instanceof Caching) {
            ((Caching)((Object)this.sorter)).flushCache();
        }
    }

    protected Object readResolve() {
        this.init();
        return this;
    }
}

