/*
 * Decompiled with CFR 0.152.
 */
package org.pitest.reloc.xstream.converters.reflection;

import java.util.Arrays;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Map;
import org.pitest.reloc.xstream.converters.reflection.FieldKey;
import org.pitest.reloc.xstream.converters.reflection.FieldKeySorter;
import org.pitest.reloc.xstream.core.Caching;
import org.pitest.reloc.xstream.core.util.OrderRetainingMap;
import org.pitest.reloc.xstream.io.StreamException;

public class SortableFieldKeySorter
implements FieldKeySorter,
Caching {
    private final Map map = new HashMap();

    public Map sort(Class type, Map keyedByFieldKey) {
        if (this.map.containsKey(type)) {
            OrderRetainingMap result = new OrderRetainingMap();
            FieldKey[] fieldKeys = keyedByFieldKey.keySet().toArray(new FieldKey[keyedByFieldKey.size()]);
            Arrays.sort(fieldKeys, (Comparator)this.map.get(type));
            for (int i = 0; i < fieldKeys.length; ++i) {
                result.put(fieldKeys[i], keyedByFieldKey.get(fieldKeys[i]));
            }
            return result;
        }
        return keyedByFieldKey;
    }

    public void registerFieldOrder(Class type, String[] fields) {
        this.map.put(type, new FieldComparator(fields));
    }

    public void flushCache() {
        this.map.clear();
    }

    private class FieldComparator
    implements Comparator {
        private final String[] fieldOrder;

        public FieldComparator(String[] fields) {
            this.fieldOrder = fields;
        }

        public int compare(String first, String second) {
            int firstPosition = -1;
            int secondPosition = -1;
            for (int i = 0; i < this.fieldOrder.length; ++i) {
                if (this.fieldOrder[i].equals(first)) {
                    firstPosition = i;
                }
                if (!this.fieldOrder[i].equals(second)) continue;
                secondPosition = i;
            }
            if (firstPosition == -1 || secondPosition == -1) {
                throw new StreamException("You have not given XStream a list of all fields to be serialized.");
            }
            return firstPosition - secondPosition;
        }

        public int compare(Object firstObject, Object secondObject) {
            FieldKey first = (FieldKey)firstObject;
            FieldKey second = (FieldKey)secondObject;
            return this.compare(first.getFieldName(), second.getFieldName());
        }
    }
}

