/*
 * Decompiled with CFR 0.152.
 */
package org.pitest.reloc.xstream.core;

import java.util.HashMap;
import java.util.Map;
import org.pitest.reloc.xstream.converters.ConversionException;
import org.pitest.reloc.xstream.converters.Converter;
import org.pitest.reloc.xstream.converters.ConverterLookup;
import org.pitest.reloc.xstream.core.TreeUnmarshaller;
import org.pitest.reloc.xstream.core.util.FastStack;
import org.pitest.reloc.xstream.io.HierarchicalStreamReader;
import org.pitest.reloc.xstream.mapper.Mapper;

public abstract class AbstractReferenceUnmarshaller
extends TreeUnmarshaller {
    private static final Object NULL = new Object();
    private Map values = new HashMap();
    private FastStack parentStack = new FastStack(16);

    public AbstractReferenceUnmarshaller(Object root, HierarchicalStreamReader reader, ConverterLookup converterLookup, Mapper mapper) {
        super(root, reader, converterLookup, mapper);
    }

    protected Object convert(Object parent, Class type, Converter converter) {
        Object result;
        String attributeName;
        String reference;
        Object parentReferenceKey;
        if (this.parentStack.size() > 0 && (parentReferenceKey = this.parentStack.peek()) != null && !this.values.containsKey(parentReferenceKey)) {
            this.values.put(parentReferenceKey, parent);
        }
        String string = reference = (attributeName = this.getMapper().aliasForSystemAttribute("reference")) == null ? null : this.reader.getAttribute(attributeName);
        if (reference != null) {
            Object cache = this.values.get(this.getReferenceKey(reference));
            if (cache == null) {
                ConversionException ex = new ConversionException("Invalid reference");
                ex.add("reference", reference);
                throw ex;
            }
            result = cache == NULL ? null : (Object)cache;
        } else {
            Object currentReferenceKey = this.getCurrentReferenceKey();
            this.parentStack.push(currentReferenceKey);
            result = super.convert(parent, type, converter);
            if (currentReferenceKey != null) {
                this.values.put(currentReferenceKey, result == null ? NULL : result);
            }
            this.parentStack.popSilently();
        }
        return result;
    }

    protected abstract Object getReferenceKey(String var1);

    protected abstract Object getCurrentReferenceKey();
}

