/*
 * Decompiled with CFR 0.152.
 */
package org.pitest.reloc.xstream.core;

import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.WeakHashMap;
import org.pitest.reloc.xstream.converters.ConversionException;
import org.pitest.reloc.xstream.converters.Converter;
import org.pitest.reloc.xstream.converters.ConverterLookup;
import org.pitest.reloc.xstream.converters.ConverterRegistry;
import org.pitest.reloc.xstream.core.Caching;
import org.pitest.reloc.xstream.core.util.PrioritizedList;
import org.pitest.reloc.xstream.mapper.Mapper;

public class DefaultConverterLookup
implements ConverterLookup,
ConverterRegistry,
Caching {
    private final PrioritizedList converters = new PrioritizedList();
    private transient Map typeToConverterMap = Collections.synchronizedMap(new WeakHashMap());

    public DefaultConverterLookup() {
    }

    public DefaultConverterLookup(Mapper mapper) {
    }

    public Converter lookupConverterForType(Class type) {
        Converter cachedConverter = (Converter)this.typeToConverterMap.get(type);
        if (cachedConverter != null) {
            return cachedConverter;
        }
        Iterator iterator = this.converters.iterator();
        while (iterator.hasNext()) {
            Converter converter = (Converter)iterator.next();
            if (!converter.canConvert(type)) continue;
            this.typeToConverterMap.put(type, converter);
            return converter;
        }
        throw new ConversionException("No converter specified for " + type);
    }

    public void registerConverter(Converter converter, int priority) {
        this.converters.add(converter, priority);
        Iterator iter = this.typeToConverterMap.keySet().iterator();
        while (iter.hasNext()) {
            Class type = (Class)iter.next();
            if (!converter.canConvert(type)) continue;
            iter.remove();
        }
    }

    public void flushCache() {
        this.typeToConverterMap.clear();
        Iterator iterator = this.converters.iterator();
        while (iterator.hasNext()) {
            Converter converter = (Converter)iterator.next();
            if (!(converter instanceof Caching)) continue;
            ((Caching)((Object)converter)).flushCache();
        }
    }

    private Object readResolve() {
        this.typeToConverterMap = Collections.synchronizedMap(new HashMap());
        return this;
    }
}

