/*
 * Decompiled with CFR 0.152.
 */
package org.pitest.reloc.xstream.io.xml;

import java.util.Iterator;
import org.pitest.reloc.xstream.converters.ErrorWriter;
import org.pitest.reloc.xstream.core.util.FastStack;
import org.pitest.reloc.xstream.io.AttributeNameIterator;
import org.pitest.reloc.xstream.io.naming.NameCoder;
import org.pitest.reloc.xstream.io.xml.AbstractXmlReader;
import org.pitest.reloc.xstream.io.xml.DocumentReader;
import org.pitest.reloc.xstream.io.xml.XmlFriendlyNameCoder;
import org.pitest.reloc.xstream.io.xml.XmlFriendlyReplacer;

public abstract class AbstractDocumentReader
extends AbstractXmlReader
implements DocumentReader {
    private FastStack pointers = new FastStack(16);
    private Object current;

    protected AbstractDocumentReader(Object rootElement) {
        this(rootElement, new XmlFriendlyNameCoder());
    }

    protected AbstractDocumentReader(Object rootElement, NameCoder nameCoder) {
        super(nameCoder);
        this.current = rootElement;
        this.pointers.push(new Pointer());
        this.reassignCurrentElement(this.current);
    }

    protected AbstractDocumentReader(Object rootElement, XmlFriendlyReplacer replacer) {
        this(rootElement, (NameCoder)replacer);
    }

    protected abstract void reassignCurrentElement(Object var1);

    protected abstract Object getParent();

    protected abstract Object getChild(int var1);

    protected abstract int getChildCount();

    public boolean hasMoreChildren() {
        Pointer pointer = (Pointer)this.pointers.peek();
        return pointer.v < this.getChildCount();
    }

    public void moveUp() {
        this.current = this.getParent();
        this.pointers.popSilently();
        this.reassignCurrentElement(this.current);
    }

    public void moveDown() {
        Pointer pointer = (Pointer)this.pointers.peek();
        this.pointers.push(new Pointer());
        this.current = this.getChild(pointer.v);
        ++pointer.v;
        this.reassignCurrentElement(this.current);
    }

    public Iterator getAttributeNames() {
        return new AttributeNameIterator(this);
    }

    public void appendErrors(ErrorWriter errorWriter) {
    }

    public Object getCurrent() {
        return this.current;
    }

    public void close() {
    }

    private static class Pointer {
        public int v;

        private Pointer() {
        }
    }
}

