/*
 * Decompiled with CFR 0.152.
 */
package org.pitest.reloc.xstream.io.xml;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import org.pitest.reloc.xmlpull.v1.XmlPullParser;
import org.pitest.reloc.xmlpull.v1.XmlPullParserException;
import org.pitest.reloc.xstream.core.util.XmlHeaderAwareReader;
import org.pitest.reloc.xstream.io.HierarchicalStreamReader;
import org.pitest.reloc.xstream.io.HierarchicalStreamWriter;
import org.pitest.reloc.xstream.io.StreamException;
import org.pitest.reloc.xstream.io.naming.NameCoder;
import org.pitest.reloc.xstream.io.xml.AbstractXmlDriver;
import org.pitest.reloc.xstream.io.xml.PrettyPrintWriter;
import org.pitest.reloc.xstream.io.xml.XppReader;

public abstract class AbstractXppDriver
extends AbstractXmlDriver {
    public AbstractXppDriver(NameCoder nameCoder) {
        super(nameCoder);
    }

    public HierarchicalStreamReader createReader(Reader in) {
        try {
            return new XppReader(in, this.createParser(), this.getNameCoder());
        }
        catch (XmlPullParserException e) {
            throw new StreamException("Cannot create XmlPullParser");
        }
    }

    public HierarchicalStreamReader createReader(InputStream in) {
        try {
            return this.createReader(new XmlHeaderAwareReader(in));
        }
        catch (UnsupportedEncodingException e) {
            throw new StreamException(e);
        }
        catch (IOException e) {
            throw new StreamException(e);
        }
    }

    public HierarchicalStreamWriter createWriter(Writer out) {
        return new PrettyPrintWriter(out, this.getNameCoder());
    }

    public HierarchicalStreamWriter createWriter(OutputStream out) {
        return this.createWriter(new OutputStreamWriter(out));
    }

    protected abstract XmlPullParser createParser() throws XmlPullParserException;
}

