/*
 * Decompiled with CFR 0.152.
 */
package org.pitest.reloc.xstream.io.xml;

import java.io.IOException;
import org.dom4j.Element;
import org.dom4j.io.XMLWriter;
import org.dom4j.tree.DefaultElement;
import org.pitest.reloc.xstream.core.util.FastStack;
import org.pitest.reloc.xstream.io.StreamException;
import org.pitest.reloc.xstream.io.naming.NameCoder;
import org.pitest.reloc.xstream.io.xml.AbstractXmlWriter;
import org.pitest.reloc.xstream.io.xml.XmlFriendlyNameCoder;
import org.pitest.reloc.xstream.io.xml.XmlFriendlyReplacer;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.AttributesImpl;

public class Dom4JXmlWriter
extends AbstractXmlWriter {
    private final XMLWriter writer;
    private final FastStack elementStack;
    private AttributesImpl attributes;
    private boolean started;
    private boolean children;

    public Dom4JXmlWriter(XMLWriter writer) {
        this(writer, new XmlFriendlyNameCoder());
    }

    public Dom4JXmlWriter(XMLWriter writer, NameCoder nameCoder) {
        super(nameCoder);
        this.writer = writer;
        this.elementStack = new FastStack(16);
        this.attributes = new AttributesImpl();
        try {
            writer.startDocument();
        }
        catch (SAXException e) {
            throw new StreamException(e);
        }
    }

    public Dom4JXmlWriter(XMLWriter writer, XmlFriendlyReplacer replacer) {
        this(writer, (NameCoder)replacer);
    }

    public void startNode(String name) {
        if (this.elementStack.size() > 0) {
            try {
                this.startElement();
            }
            catch (SAXException e) {
                throw new StreamException(e);
            }
            this.started = false;
        }
        this.elementStack.push(this.encodeNode(name));
        this.children = false;
    }

    public void setValue(String text) {
        char[] value = text.toCharArray();
        if (value.length > 0) {
            try {
                this.startElement();
                this.writer.characters(value, 0, value.length);
            }
            catch (SAXException e) {
                throw new StreamException(e);
            }
            this.children = true;
        }
    }

    public void addAttribute(String key, String value) {
        this.attributes.addAttribute("", "", this.encodeAttribute(key), "string", value);
    }

    public void endNode() {
        try {
            if (!this.children) {
                DefaultElement element = new DefaultElement((String)this.elementStack.pop());
                for (int i = 0; i < this.attributes.getLength(); ++i) {
                    element.addAttribute(this.attributes.getQName(i), this.attributes.getValue(i));
                }
                this.writer.write((Element)element);
                this.attributes.clear();
                this.children = true;
                this.started = true;
            } else {
                this.startElement();
                this.writer.endElement("", "", (String)this.elementStack.pop());
            }
        }
        catch (SAXException e) {
            throw new StreamException(e);
        }
        catch (IOException e) {
            throw new StreamException(e);
        }
    }

    public void flush() {
        try {
            this.writer.flush();
        }
        catch (IOException e) {
            throw new StreamException(e);
        }
    }

    public void close() {
        try {
            this.writer.endDocument();
        }
        catch (SAXException e) {
            throw new StreamException(e);
        }
    }

    private void startElement() throws SAXException {
        if (!this.started) {
            this.writer.startElement("", "", (String)this.elementStack.peek(), (Attributes)this.attributes);
            this.attributes.clear();
            this.started = true;
        }
    }
}

