/*
 * Decompiled with CFR 0.152.
 */
package org.pitest.reloc.xstream.io.xml;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import java.net.URL;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.FactoryConfigurationError;
import javax.xml.parsers.ParserConfigurationException;
import org.pitest.reloc.xstream.io.HierarchicalStreamReader;
import org.pitest.reloc.xstream.io.HierarchicalStreamWriter;
import org.pitest.reloc.xstream.io.StreamException;
import org.pitest.reloc.xstream.io.naming.NameCoder;
import org.pitest.reloc.xstream.io.xml.AbstractXmlDriver;
import org.pitest.reloc.xstream.io.xml.DomReader;
import org.pitest.reloc.xstream.io.xml.PrettyPrintWriter;
import org.pitest.reloc.xstream.io.xml.XmlFriendlyNameCoder;
import org.pitest.reloc.xstream.io.xml.XmlFriendlyReplacer;
import org.w3c.dom.Document;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class DomDriver
extends AbstractXmlDriver {
    private final String encoding;
    private final DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();

    public DomDriver() {
        this((String)null);
    }

    public DomDriver(String encoding) {
        this(encoding, new XmlFriendlyNameCoder());
    }

    public DomDriver(String encoding, NameCoder nameCoder) {
        super(nameCoder);
        this.encoding = encoding;
    }

    public DomDriver(String encoding, XmlFriendlyReplacer replacer) {
        this(encoding, (NameCoder)replacer);
    }

    public HierarchicalStreamReader createReader(Reader in) {
        return this.createReader(new InputSource(in));
    }

    public HierarchicalStreamReader createReader(InputStream in) {
        return this.createReader(new InputSource(in));
    }

    public HierarchicalStreamReader createReader(URL in) {
        return this.createReader(new InputSource(in.toExternalForm()));
    }

    public HierarchicalStreamReader createReader(File in) {
        return this.createReader(new InputSource(in.toURI().toASCIIString()));
    }

    private HierarchicalStreamReader createReader(InputSource source) {
        try {
            DocumentBuilder documentBuilder = this.documentBuilderFactory.newDocumentBuilder();
            if (this.encoding != null) {
                source.setEncoding(this.encoding);
            }
            Document document = documentBuilder.parse(source);
            return new DomReader(document, this.getNameCoder());
        }
        catch (FactoryConfigurationError e) {
            throw new StreamException(e);
        }
        catch (ParserConfigurationException e) {
            throw new StreamException(e);
        }
        catch (SAXException e) {
            throw new StreamException(e);
        }
        catch (IOException e) {
            throw new StreamException(e);
        }
    }

    public HierarchicalStreamWriter createWriter(Writer out) {
        return new PrettyPrintWriter(out, this.getNameCoder());
    }

    public HierarchicalStreamWriter createWriter(OutputStream out) {
        try {
            return this.createWriter(this.encoding != null ? new OutputStreamWriter(out, this.encoding) : new OutputStreamWriter(out));
        }
        catch (UnsupportedEncodingException e) {
            throw new StreamException(e);
        }
    }
}

