/*
 * Decompiled with CFR 0.152.
 */
package org.pitest.reloc.xstream.mapper;

import java.lang.ref.WeakReference;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.pitest.reloc.xstream.core.Caching;
import org.pitest.reloc.xstream.mapper.Mapper;
import org.pitest.reloc.xstream.mapper.MapperWrapper;

public class CachingMapper
extends MapperWrapper
implements Caching {
    private transient Map realClassCache;

    public CachingMapper(Mapper wrapped) {
        super(wrapped);
        this.readResolve();
    }

    public Class realClass(String elementName) {
        Class cached;
        WeakReference reference = (WeakReference)this.realClassCache.get(elementName);
        if (reference != null && (cached = (Class)reference.get()) != null) {
            return cached;
        }
        Class result = super.realClass(elementName);
        this.realClassCache.put(elementName, new WeakReference<Class>(result));
        return result;
    }

    public void flushCache() {
        this.realClassCache.clear();
    }

    private Object readResolve() {
        this.realClassCache = Collections.synchronizedMap(new HashMap(128));
        return this;
    }
}

