/*
 * Decompiled with CFR 0.152.
 */
package org.pitest.testapi;

import java.io.Serializable;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class Description
implements Serializable {
    private static final long serialVersionUID = 1L;
    private final String testClass;
    private final String name;

    public Description(String name) {
        this(name, (String)null);
    }

    public Description(String name, Class<?> testClass) {
        this(name, testClass.getName());
    }

    public Description(String name, String testClass) {
        this.testClass = this.internIfNotNull(testClass);
        this.name = name;
    }

    private String internIfNotNull(String string) {
        if (string == null) {
            return null;
        }
        return string.intern();
    }

    public String getFirstTestClass() {
        return this.testClass;
    }

    public String getQualifiedName() {
        if (this.testClass != null) {
            return this.getFirstTestClass() + "." + this.getName();
        }
        return this.getName();
    }

    public String getName() {
        return this.name;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.name == null ? 0 : this.name.hashCode());
        result = 31 * result + (this.testClass == null ? 0 : this.testClass.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Description other = (Description)obj;
        if (this.name == null ? other.name != null : !this.name.equals(other.name)) {
            return false;
        }
        return !(this.testClass == null ? other.testClass != null : !this.testClass.equals(other.testClass));
    }

    public String toString() {
        return "Description [testClass=" + this.testClass + ", name=" + this.name + "]";
    }
}

