/*
 * Decompiled with CFR 0.152.
 */
package org.pitest.testng;

import java.util.Collections;
import java.util.List;
import org.pitest.testapi.AbstractTestUnit;
import org.pitest.testapi.Description;
import org.pitest.testapi.ResultCollector;
import org.pitest.testapi.TestGroupConfig;
import org.pitest.testapi.foreignclassloader.Events;
import org.pitest.testng.ForeignClassLoaderTestNGExecutor;
import org.pitest.testng.TestNGAdapter;
import org.pitest.util.ClassLoaderDetectionStrategy;
import org.pitest.util.IsolationUtils;
import org.pitest.util.Unchecked;
import org.testng.ITestListener;
import org.testng.TestNG;
import org.testng.xml.XmlClass;
import org.testng.xml.XmlSuite;
import org.testng.xml.XmlTest;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TestNGTestUnit
extends AbstractTestUnit {
    private final ClassLoaderDetectionStrategy classloaderDetection;
    private final Class<?> clazz;
    private final TestGroupConfig config;

    public TestNGTestUnit(ClassLoaderDetectionStrategy classloaderDetection, Class<?> clazz, TestGroupConfig config) {
        super(new Description("_", clazz));
        this.clazz = clazz;
        this.classloaderDetection = classloaderDetection;
        this.config = config;
    }

    public TestNGTestUnit(Class<?> clazz, TestGroupConfig config) {
        this(IsolationUtils.loaderDetectionStrategy(), clazz, config);
    }

    @Override
    public void execute(ClassLoader loader, ResultCollector rc) {
        if (this.classloaderDetection.fromDifferentLoader(this.clazz, loader)) {
            this.executeInForeignLoader(rc, loader);
        } else {
            this.executeInCurrentLoader(rc);
        }
    }

    private void executeInForeignLoader(ResultCollector rc, ClassLoader loader) {
        ForeignClassLoaderTestNGExecutor e = new ForeignClassLoaderTestNGExecutor(this.createSuite());
        try {
            Object q = e.call();
            Events.applyEvents((List<String>)q, rc, this.getDescription());
        }
        catch (Exception ex) {
            throw Unchecked.translateCheckedException(ex);
        }
    }

    private void executeInCurrentLoader(ResultCollector rc) {
        TestNGAdapter listener = new TestNGAdapter(this.clazz, this.getDescription(), rc);
        TestNG testng = new TestNG(false);
        XmlSuite suite = this.createSuite();
        testng.setDefaultSuiteName(suite.getName());
        testng.setXmlSuites(Collections.singletonList(suite));
        testng.addListener((ITestListener)listener);
        testng.run();
    }

    private XmlSuite createSuite() {
        XmlSuite suite = new XmlSuite();
        suite.setName(this.clazz.getName());
        XmlTest test = new XmlTest(suite);
        test.setName(this.clazz.getName());
        XmlClass xclass = new XmlClass(this.clazz.getName());
        test.setXmlClasses(Collections.singletonList(xclass));
        if (!this.config.getExcludedGroups().isEmpty()) {
            suite.setExcludedGroups(this.config.getExcludedGroups());
        }
        if (!this.config.getIncludedGroups().isEmpty()) {
            suite.setIncludedGroups(this.config.getIncludedGroups());
        }
        return suite;
    }
}

