/*
 * Decompiled with CFR 0.152.
 */
package org.pitest.testng;

import java.util.Collections;
import java.util.List;
import org.pitest.functional.FCollection;
import org.pitest.reflection.IsAnnotatedWith;
import org.pitest.reflection.Reflection;
import org.pitest.testapi.TestGroupConfig;
import org.pitest.testapi.TestUnit;
import org.pitest.testapi.TestUnitFinder;
import org.pitest.testng.TestNGTestUnit;
import org.testng.annotations.Test;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TestNGTestUnitFinder
implements TestUnitFinder {
    private final TestGroupConfig config;

    public TestNGTestUnitFinder(TestGroupConfig config) {
        this.config = config;
    }

    @Override
    public List<TestUnit> findTestUnits(Class<?> clazz) {
        if (this.hasClassAnnotation(clazz) || this.hasMethodAnnotation(clazz)) {
            return Collections.singletonList(new TestNGTestUnit(clazz, this.config));
        }
        return Collections.emptyList();
    }

    private boolean hasClassAnnotation(Class<?> clazz) {
        return clazz.getAnnotation(Test.class) != null;
    }

    private boolean hasMethodAnnotation(Class<?> clazz) {
        return FCollection.contains(Reflection.allMethods(clazz), IsAnnotatedWith.instance(Test.class));
    }
}

