/*
 * Decompiled with CFR 0.152.
 */
package org.pitest.util;

import java.util.Map;
import org.pitest.classinfo.ClassByteArraySource;
import org.pitest.reloc.asm.ClassReader;
import org.pitest.reloc.asm.ClassWriter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ComputeClassWriter
extends ClassWriter {
    private final ClassByteArraySource bytes;
    private final Map<String, String> cache;

    public ComputeClassWriter(ClassByteArraySource bytes, Map<String, String> cache, int flags) {
        super(flags);
        this.bytes = bytes;
        this.cache = cache;
    }

    @Override
    protected String getCommonSuperClass(String type1, String type2) {
        String key = type1 + "!_!" + type2;
        String previous = this.cache.get(key);
        if (previous != null) {
            return previous;
        }
        ClassReader info1 = this.typeInfo(type1);
        ClassReader info2 = this.typeInfo(type2);
        String result = this.getCommonSuperClass(type1, info1, type2, info2);
        this.cache.put(key, result);
        return result;
    }

    private String getCommonSuperClass(String type1, ClassReader info1, String type2, ClassReader info2) {
        String result;
        block5: {
            if (this.isInterface(info1)) {
                if (this.typeImplements(type2, info2, type1)) {
                    return type1;
                }
                if (this.isInterface(info2)) {
                    if (this.typeImplements(type1, info1, type2)) {
                        return type2;
                    }
                    return "java/lang/Object";
                }
            }
            StringBuilder b1 = this.typeAncestors(type1, info1);
            StringBuilder b2 = this.typeAncestors(type2, info2);
            result = "java/lang/Object";
            int end1 = b1.length();
            int end2 = b2.length();
            while (true) {
                String p2;
                int start1 = b1.lastIndexOf(";", end1 - 1);
                int start2 = b2.lastIndexOf(";", end2 - 1);
                if (start1 == -1 || start2 == -1 || end1 - start1 != end2 - start2) break block5;
                String p1 = b1.substring(start1 + 1, end1);
                if (!p1.equals(p2 = b2.substring(start2 + 1, end2))) break;
                result = p1;
                end1 = start1;
                end2 = start2;
            }
            return result;
        }
        return result;
    }

    private boolean isInterface(ClassReader info1) {
        return (info1.getAccess() & 0x200) != 0;
    }

    private StringBuilder typeAncestors(String type, ClassReader info) {
        StringBuilder b = new StringBuilder();
        while (!"java/lang/Object".equals(type)) {
            b.append(';').append(type);
            type = info.getSuperName();
            info = this.typeInfo(type);
        }
        return b;
    }

    private boolean typeImplements(String type, ClassReader info, String itf) {
        String cleanItf = itf.replace(".", "/");
        while (!"java/lang/Object".equals(type)) {
            String[] itfs;
            for (String itf2 : itfs = info.getInterfaces()) {
                if (!itf2.equals(cleanItf)) continue;
                return true;
            }
            for (String itf2 : itfs) {
                if (!this.typeImplements(itf2, this.typeInfo(itf2), cleanItf)) continue;
                return true;
            }
            type = info.getSuperName();
            info = this.typeInfo(type);
        }
        return false;
    }

    private ClassReader typeInfo(String type) {
        return new ClassReader(this.bytes.getBytes(type).value());
    }
}

