/*
 * Decompiled with CFR 0.152.
 */
package org.pitest.util;

import java.util.logging.Logger;
import org.pitest.classinfo.ClassName;
import org.pitest.functional.F;
import org.pitest.functional.Option;
import org.pitest.functional.predicate.Predicate;
import org.pitest.util.IsolationUtils;
import org.pitest.util.Log;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class Functions {
    private static final Logger LOG = Log.getLogger();

    public static F<String, String> classNameToJVMClassName() {
        return new F<String, String>(){

            @Override
            public String apply(String a) {
                return a.replace(".", "/");
            }
        };
    }

    public static F<String, String> jvmClassToClassName() {
        return new F<String, String>(){

            @Override
            public String apply(String a) {
                return a.replace("/", ".");
            }
        };
    }

    public static F<Class<?>, String> classToName() {
        return new F<Class<?>, String>(){

            @Override
            public String apply(Class<?> clazz) {
                return clazz.getName();
            }
        };
    }

    public static F<ClassName, Option<Class<?>>> nameToClass() {
        return Functions.nameToClass(IsolationUtils.getContextClassLoader());
    }

    public static F<ClassName, Option<Class<?>>> nameToClass(final ClassLoader loader) {
        return new F<ClassName, Option<Class<?>>>(){

            @Override
            public Option<Class<?>> apply(ClassName className) {
                try {
                    Class<?> clazz = Class.forName(className.asJavaName(), false, loader);
                    return Option.some(clazz);
                }
                catch (ClassNotFoundException e) {
                    LOG.warning("Could not load " + className + " (ClassNotFoundException: " + e.getMessage() + ")");
                    return Option.none();
                }
                catch (NoClassDefFoundError e) {
                    LOG.warning("Could not load " + className + " (NoClassDefFoundError: " + e.getMessage() + ")");
                    return Option.none();
                }
                catch (LinkageError e) {
                    LOG.warning("Could not load " + className + " " + e.getMessage());
                    return Option.none();
                }
                catch (SecurityException e) {
                    LOG.warning("Could not load " + className + " " + e.getMessage());
                    return Option.none();
                }
            }
        };
    }

    public static Predicate<String> startsWith(final String filter) {
        return new Predicate<String>(){

            @Override
            public Boolean apply(String a) {
                return a.startsWith(filter);
            }
        };
    }

    public static <T extends Enum<T>> F<String, T> stringToEnum(final Class<T> clazz) {
        return new F<String, T>(){

            @Override
            public T apply(String name) {
                return Enum.valueOf(clazz, name);
            }
        };
    }
}

