/*
 * Decompiled with CFR 0.152.
 */
package org.pitest.util;

import java.util.Collection;
import java.util.regex.Pattern;
import org.pitest.functional.F;
import org.pitest.functional.FCollection;
import org.pitest.functional.predicate.Predicate;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Glob
implements Predicate<String> {
    private final String regex;

    public Glob(String glob) {
        this.regex = Glob.convertGlobToRegex(glob);
    }

    public boolean matches(CharSequence seq) {
        return Pattern.matches(this.regex, seq);
    }

    public static F<String, Predicate<String>> toGlobPredicate() {
        return new F<String, Predicate<String>>(){

            @Override
            public Glob apply(String glob) {
                return new Glob(glob);
            }
        };
    }

    public static Collection<Predicate<String>> toGlobPredicates(Collection<String> globs) {
        return FCollection.map(globs, Glob.toGlobPredicate());
    }

    private static String convertGlobToRegex(String glob) {
        StringBuilder out = new StringBuilder("^");
        block7: for (int i = 0; i < glob.length(); ++i) {
            char c = glob.charAt(i);
            switch (c) {
                case '$': {
                    out.append("\\$");
                    continue block7;
                }
                case '*': {
                    out.append(".*");
                    continue block7;
                }
                case '?': {
                    out.append('.');
                    continue block7;
                }
                case '.': {
                    out.append("\\.");
                    continue block7;
                }
                case '\\': {
                    out.append("\\\\");
                    continue block7;
                }
                default: {
                    out.append(c);
                }
            }
        }
        out.append('$');
        return out.toString();
    }

    @Override
    public Boolean apply(String value) {
        return this.matches(value);
    }

    public String toString() {
        return this.regex;
    }
}

