/*
 * Decompiled with CFR 0.152.
 */
package org.pitest.util;

import java.io.IOException;
import java.io.StringWriter;
import java.util.WeakHashMap;
import org.pitest.reloc.xstream.XStream;
import org.pitest.reloc.xstream.core.util.Base64Encoder;
import org.pitest.reloc.xstream.io.xml.CompactWriter;
import org.pitest.util.ClassLoaderDetectionStrategy;
import org.pitest.util.PitXmlDriver;
import org.pitest.util.Unchecked;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class IsolationUtils {
    private static final XStream XSTREAM_INSTANCE = new XStream(new PitXmlDriver());
    private static final WeakHashMap<ClassLoader, XStream> CACHE = new WeakHashMap();
    private static final ClassLoaderDetectionStrategy LOADER_DETECTION_STRATEGY = new ClassLoaderDetectionStrategy(){

        @Override
        public boolean fromDifferentLoader(Class<?> clazz, ClassLoader loader) {
            return IsolationUtils.fromIncompatibleLoader(clazz, loader);
        }
    };

    public static ClassLoaderDetectionStrategy loaderDetectionStrategy() {
        return LOADER_DETECTION_STRATEGY;
    }

    public static ClassLoader getContextClassLoader() {
        return Thread.currentThread().getContextClassLoader();
    }

    public static Object cloneForLoader(Object o, ClassLoader loader) {
        try {
            String xml = IsolationUtils.toXml(o);
            XStream foreignXstream = IsolationUtils.getXStreamForLoader(loader);
            return foreignXstream.fromXML(xml);
        }
        catch (Exception ex) {
            throw Unchecked.translateCheckedException(ex);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static XStream getXStreamForLoader(ClassLoader loader) {
        XStream foreginXstream = CACHE.get(loader);
        if (foreginXstream == null) {
            foreginXstream = new XStream(new PitXmlDriver());
            foreginXstream.setClassLoader(loader);
            WeakHashMap<ClassLoader, XStream> weakHashMap = CACHE;
            synchronized (weakHashMap) {
                CACHE.put(loader, foreginXstream);
            }
        }
        return foreginXstream;
    }

    private static boolean fromIncompatibleLoader(Class<?> clazz, ClassLoader loader) {
        ClassLoader target = clazz.getClassLoader();
        if (target == IsolationUtils.bootClassLoader() || loader == IsolationUtils.bootClassLoader()) {
            return false;
        }
        while (target != IsolationUtils.bootClassLoader()) {
            if (target == loader) {
                return false;
            }
            target = target.getParent();
        }
        return true;
    }

    public static Class<?> convertForClassLoader(ClassLoader loader, String name) {
        try {
            return Class.forName(name, false, loader);
        }
        catch (ClassNotFoundException ex) {
            throw Unchecked.translateCheckedException(ex);
        }
    }

    public static Class<?> convertForClassLoader(ClassLoader loader, Class<?> clazz) {
        if (clazz.getClassLoader() != loader) {
            return IsolationUtils.convertForClassLoader(loader, clazz.getName());
        }
        return clazz;
    }

    public static String toXml(Object o) {
        StringWriter writer = new StringWriter();
        XSTREAM_INSTANCE.marshal(o, new CompactWriter(writer));
        return ((Object)writer).toString();
    }

    public static String decodeTransportString(String encodedXml) throws IOException {
        Base64Encoder encoder = new Base64Encoder();
        return new String(encoder.decode(encodedXml), "UTF-8");
    }

    public static Object fromXml(String xml) {
        return XSTREAM_INSTANCE.fromXML(xml);
    }

    public static Object clone(Object object) {
        return IsolationUtils.cloneForLoader(object, IsolationUtils.getContextClassLoader());
    }

    public static ClassLoader bootClassLoader() {
        return Object.class.getClassLoader();
    }
}

