/*
 * Decompiled with CFR 0.152.
 */
package org.pitest.util;

import java.lang.management.ManagementFactory;
import java.lang.management.MemoryMXBean;
import java.lang.management.MemoryPoolMXBean;
import java.lang.management.MemoryUsage;
import java.util.List;
import javax.management.NotificationEmitter;
import javax.management.NotificationListener;

public class MemoryWatchdog {
    public static void addWatchDogToAllPools(long threshold, NotificationListener listener) {
        MemoryMXBean memBean = ManagementFactory.getMemoryMXBean();
        NotificationEmitter ne = (NotificationEmitter)((Object)memBean);
        ne.addNotificationListener(listener, null, null);
        List<MemoryPoolMXBean> memPools = ManagementFactory.getMemoryPoolMXBeans();
        for (MemoryPoolMXBean mp : memPools) {
            if (!mp.isUsageThresholdSupported()) continue;
            MemoryUsage mu = mp.getUsage();
            long max = mu.getMax();
            long alert = max * threshold / 100L;
            mp.setUsageThreshold(alert);
        }
    }
}

