/*
 * Decompiled with CFR 0.152.
 */
package org.pitest.util;

import java.lang.management.ManagementFactory;
import java.lang.management.RuntimeMXBean;
import java.util.List;
import org.pitest.functional.F2;
import org.pitest.functional.FCollection;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class PitError
extends RuntimeException {
    private static final long serialVersionUID = 1L;

    public PitError(String message, Throwable cause) {
        super(message + PitError.info(), cause);
    }

    public PitError(String message) {
        super(message + PitError.info());
    }

    private static String info() {
        RuntimeMXBean rt = ManagementFactory.getRuntimeMXBean();
        return "\n\nPlease copy and paste the information and the complete stacktrace below when reporting an issue\nVM : " + rt.getVmName() + "\n" + "Vendor : " + rt.getVmVendor() + "\n" + "Version : " + rt.getVmVersion() + "\n" + "Uptime : " + rt.getUptime() + "\n" + "Input -> " + PitError.createInputString(rt.getInputArguments()) + "\n" + "BootClassPathSupported : " + rt.isBootClassPathSupported() + "\n";
    }

    private static String createInputString(List<String> inputArguments) {
        StringBuilder sb = new StringBuilder();
        FCollection.fold(PitError.append(), sb, inputArguments);
        return sb.toString();
    }

    private static F2<StringBuilder, String, StringBuilder> append() {
        return new F2<StringBuilder, String, StringBuilder>(){
            private int position = 0;

            @Override
            public StringBuilder apply(StringBuilder a, String b) {
                ++this.position;
                return a.append("\n " + this.position + " : " + b);
            }
        };
    }
}

